/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.rendering.BoundingVolume;

public class BoundingSphere
extends BoundingVolume {
    private float[] center;
    private float radiusSquared;
    private float radius;

    public BoundingSphere() {
        this.center = new float[3];
        this.radiusSquared = 1.0f;
        this.radius = 1.0f;
    }

    public BoundingSphere(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative radius value");
        }
        this.center = new float[3];
        this.radiusSquared = f * f;
        this.radius = f;
    }

    public BoundingSphere(float[] fArray, float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative radius value");
        }
        this.center = new float[]{fArray[0], fArray[1], fArray[2]};
        this.radiusSquared = f * f;
        this.radius = f;
    }

    public int getType() {
        return 1;
    }

    public void getExtents(float[] fArray, float[] fArray2) {
        fArray[0] = this.center[0] - this.radius;
        fArray[1] = this.center[1] - this.radius;
        fArray[2] = this.center[2] - this.radius;
        fArray2[0] = this.center[0] + this.radius;
        fArray2[1] = this.center[1] + this.radius;
        fArray2[2] = this.center[2] + this.radius;
    }

    public void getCenter(float[] fArray) {
        fArray[0] = this.center[0];
        fArray[1] = this.center[1];
        fArray[2] = this.center[2];
    }

    public boolean checkIntersectionPoint(float[] fArray) {
        float f = fArray[0] - this.center[0];
        float f2 = fArray[1] - this.center[1];
        float f3 = fArray[2] - this.center[2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        return f4 <= this.radiusSquared;
    }

    public boolean checkIntersectionLine(float[] fArray) {
        return false;
    }

    public boolean checkIntersectionRay(float[] fArray, float[] fArray2) {
        return this.raySphere(fArray, fArray2);
    }

    public boolean checkIntersectionSegment(float[] fArray, float[] fArray2) {
        return false;
    }

    public boolean checkIntersectionSegment(float[] fArray, float[] fArray2, float f) {
        return false;
    }

    public boolean checkIntersectionSphere(float[] fArray, float f) {
        float f2 = fArray[0] - this.center[0];
        float f3 = fArray[1] - this.center[1];
        float f4 = fArray[2] - this.center[2];
        float f5 = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        return f5 <= this.radius + f;
    }

    public boolean checkIntersectionCylinder(float[] fArray, float[] fArray2, float f, float f2) {
        return false;
    }

    public boolean checkIntersectionCone(float[] fArray, float[] fArray2, float f) {
        return false;
    }

    public boolean checkIntersectionBox(float[] fArray, float[] fArray2) {
        float f;
        float f2 = 0.0f;
        if (this.center[0] < fArray[0]) {
            f = this.center[0] - fArray[0];
            f2 += f * f;
        } else if (this.center[0] > fArray2[0]) {
            f = this.center[0] - fArray2[0];
            f2 += f * f;
        }
        if (this.center[1] < fArray[1]) {
            f = this.center[1] - fArray[1];
            f2 += f * f;
        } else if (this.center[1] > fArray2[1]) {
            f = this.center[1] - fArray2[1];
            f2 += f * f;
        }
        if (this.center[2] < fArray[2]) {
            f = this.center[2] - fArray[2];
            f2 += f * f;
        } else if (this.center[2] > fArray2[2]) {
            f = this.center[2] - fArray2[2];
            f2 += f * f;
        }
        return f2 <= this.radiusSquared;
    }

    public int checkIntersectionFrustum(Vector4f[] vector4fArray, Matrix4d matrix4d) {
        return 1;
    }

    public int checkIntersectionFrustum(Vector4f[] vector4fArray, Matrix4f matrix4f) {
        return 1;
    }

    public void transform(Matrix4d matrix4d) {
    }

    public void transform(Matrix4f matrix4f) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Bounding Sphere: center: ( ");
        stringBuffer.append(this.center[0]);
        stringBuffer.append(' ');
        stringBuffer.append(this.center[1]);
        stringBuffer.append(' ');
        stringBuffer.append(this.center[2]);
        stringBuffer.append(") r: ");
        stringBuffer.append(this.radius);
        return stringBuffer.toString();
    }

    public void setCenter(float[] fArray) {
        this.center[0] = fArray[0];
        this.center[1] = fArray[1];
        this.center[2] = fArray[2];
    }

    public void setRadius(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative radius value");
        }
        this.radiusSquared = f * f;
        this.radius = f;
    }

    public float getRadius() {
        return this.radius;
    }

    void setRadius(float f, float f2) {
        this.radiusSquared = f2;
        this.radius = f;
    }

    float getRadiusSquared() {
        return this.radiusSquared;
    }

    private boolean raySphere(float[] fArray, float[] fArray2) {
        double d = fArray2[0];
        double d2 = fArray[0];
        double d3 = this.center[0];
        double d4 = fArray2[1];
        double d5 = fArray[1];
        double d6 = this.center[1];
        double d7 = fArray2[2];
        double d8 = fArray[2];
        double d9 = this.center[2];
        double d10 = 2.0 * (d * (d2 - d3) + d4 * (d5 - d6) + d7 * (d8 - d9));
        double d11 = d * d + d4 * d4 + d7 * d7;
        double d12 = (d2 - d3) * (d2 - d3) + (d5 - d6) * (d5 - d6) + (d8 - d9) * (d8 - d9) - (double)this.radiusSquared;
        double d13 = d10 * d10 - 4.0 * d11 * d12;
        return d13 >= 0.0;
    }
}

