/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.rendering.BoundingVolume;

public class BoundingBox
extends BoundingVolume {
    private Point3f min = new Point3f();
    private Point4f max = new Point4f();
    private float[] center = new float[3];
    private float[] size = new float[3];
    private float[][] vert = new float[8][];
    private float[][] xvert = new float[8][];

    public BoundingBox() {
        for (int i = 0; i < 8; ++i) {
            this.vert[i] = new float[3];
            this.xvert[i] = new float[3];
        }
        this.max.w = 0.0f;
    }

    public BoundingBox(float[] fArray, float[] fArray2) {
        this();
        this.min.x = fArray[0];
        this.min.y = fArray[1];
        this.min.z = fArray[2];
        this.max.x = fArray2[0];
        this.max.y = fArray2[1];
        this.max.z = fArray2[2];
        this.recalcExtents();
    }

    public int getType() {
        return 2;
    }

    public void getExtents(float[] fArray, float[] fArray2) {
        fArray[0] = this.min.x;
        fArray[1] = this.min.y;
        fArray[2] = this.min.z;
        fArray2[0] = this.max.x;
        fArray2[1] = this.max.y;
        fArray2[2] = this.max.z;
    }

    public void getCenter(float[] fArray) {
        fArray[0] = this.center[0];
        fArray[1] = this.center[1];
        fArray[2] = this.center[2];
    }

    public void getSize(float[] fArray) {
        fArray[0] = this.size[0];
        fArray[1] = this.size[1];
        fArray[2] = this.size[2];
    }

    public boolean checkIntersectionPoint(float[] fArray) {
        return fArray[0] >= this.min.x && fArray[0] <= this.max.x && fArray[1] >= this.min.y && fArray[1] <= this.max.y && fArray[2] >= this.min.z && fArray[2] <= this.max.z;
    }

    public boolean checkIntersectionRay(float[] fArray, float[] fArray2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = true;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (fArray[0] < this.min.x) {
            bl3 = false;
            f = this.min.x;
            bl4 = false;
        } else if (fArray[0] > this.max.x) {
            bl3 = false;
            f = this.max.x;
            bl4 = false;
        } else {
            bl3 = true;
        }
        if (fArray[1] < this.min.y) {
            bl2 = false;
            f2 = this.min.y;
            bl4 = false;
        } else if (fArray[1] > this.max.y) {
            bl2 = false;
            f2 = this.max.y;
            bl4 = false;
        } else {
            bl2 = true;
        }
        if (fArray[2] < this.min.z) {
            bl = false;
            f3 = this.min.z;
            bl4 = false;
        } else if (fArray[2] > this.max.z) {
            bl = false;
            f3 = this.max.z;
            bl4 = false;
        } else {
            bl = true;
        }
        if (bl4) {
            return true;
        }
        float f4 = !bl3 && fArray2[0] != 0.0f ? (f - fArray[0]) / fArray2[0] : -1.0f;
        float f5 = !bl2 && fArray2[1] != 0.0f ? (f2 - fArray[1]) / fArray2[1] : -1.0f;
        float f6 = !bl && fArray2[2] != 0.0f ? (f3 - fArray[2]) / fArray2[2] : -1.0f;
        float f7 = f4;
        int n = 0;
        if (f7 < f5) {
            n = 1;
            f7 = f5;
        }
        if (f7 < f6) {
            n = 2;
            f7 = f6;
        }
        boolean bl5 = true;
        if (f7 < 0.0f) {
            bl5 = false;
        } else {
            float f8;
            if (n != 0 && ((f8 = fArray[0] + f7 * fArray2[0]) < this.min.x || f8 > this.max.x)) {
                bl5 = false;
            }
            if (n != 1 && bl5 && ((f8 = fArray[1] + f7 * fArray2[1]) < this.min.y || f8 > this.max.y)) {
                bl5 = false;
            }
            if (n != 2 && bl5 && ((f8 = fArray[2] + f7 * fArray2[2]) < this.min.z || f8 > this.max.z)) {
                bl5 = false;
            }
        }
        return bl5;
    }

    public boolean checkIntersectionSphere(float[] fArray, float f) {
        float f2;
        float f3 = f * f;
        float f4 = 0.0f;
        if (fArray[0] < this.min.x) {
            f2 = fArray[0] - this.min.x;
            f4 += f2 * f2;
        } else if (fArray[0] > this.max.x) {
            f2 = fArray[0] - this.max.x;
            f4 += f2 * f2;
        }
        if (fArray[1] < this.min.y) {
            f2 = fArray[1] - this.min.y;
            f4 += f2 * f2;
        } else if (fArray[1] > this.max.y) {
            f2 = fArray[1] - this.max.y;
            f4 += f2 * f2;
        }
        if (fArray[2] < this.min.z) {
            f2 = fArray[2] - this.min.z;
            f4 += f2 * f2;
        } else if (fArray[2] > this.max.z) {
            f2 = fArray[2] - this.max.z;
            f4 += f2 * f2;
        }
        return f4 <= f3;
    }

    public boolean checkIntersectionCylinder(float[] fArray, float[] fArray2, float f, float f2) {
        return false;
    }

    public boolean checkIntersectionCone(float[] fArray, float[] fArray2, float f) {
        return false;
    }

    public boolean checkIntersectionBox(float[] fArray, float[] fArray2) {
        return fArray[0] <= this.max.x && fArray[1] <= this.max.y && fArray[2] <= this.max.z && fArray2[0] >= this.min.x && fArray2[1] >= this.min.y && fArray2[2] >= this.min.z;
    }

    public int checkIntersectionFrustum(Vector4f[] vector4fArray, Matrix4d matrix4d) {
        int n;
        for (n = 0; n < 8; ++n) {
            double d = this.vert[n][0];
            double d2 = this.vert[n][1];
            double d3 = this.vert[n][2];
            this.xvert[n][0] = (float)(matrix4d.m00 * d + matrix4d.m01 * d2 + matrix4d.m02 * d3 + matrix4d.m03);
            this.xvert[n][1] = (float)(matrix4d.m10 * d + matrix4d.m11 * d2 + matrix4d.m12 * d3 + matrix4d.m13);
            this.xvert[n][2] = (float)(matrix4d.m20 * d + matrix4d.m21 * d2 + matrix4d.m22 * d3 + matrix4d.m23);
        }
        int n2 = 0;
        for (int i = 0; i < 6; ++i) {
            n = 0;
            if (vector4fArray[i].x * this.xvert[0][0] + vector4fArray[i].y * this.xvert[0][1] + vector4fArray[i].z * this.xvert[0][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[1][0] + vector4fArray[i].y * this.xvert[1][1] + vector4fArray[i].z * this.xvert[1][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[2][0] + vector4fArray[i].y * this.xvert[2][1] + vector4fArray[i].z * this.xvert[2][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[3][0] + vector4fArray[i].y * this.xvert[3][1] + vector4fArray[i].z * this.xvert[3][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[4][0] + vector4fArray[i].y * this.xvert[4][1] + vector4fArray[i].z * this.xvert[4][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[5][0] + vector4fArray[i].y * this.xvert[5][1] + vector4fArray[i].z * this.xvert[5][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[6][0] + vector4fArray[i].y * this.xvert[6][1] + vector4fArray[i].z * this.xvert[6][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[7][0] + vector4fArray[i].y * this.xvert[7][1] + vector4fArray[i].z * this.xvert[7][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (n == 0) {
                return 0;
            }
            if (n != 8) continue;
            ++n2;
        }
        return n2 == 6 ? 2 : 1;
    }

    public int checkIntersectionFrustum(Vector4f[] vector4fArray, Matrix4f matrix4f) {
        int n;
        for (n = 0; n < 8; ++n) {
            float f = this.vert[n][0];
            float f2 = this.vert[n][1];
            float f3 = this.vert[n][2];
            this.xvert[n][0] = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
            this.xvert[n][1] = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
            this.xvert[n][2] = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
        }
        int n2 = 0;
        for (int i = 0; i < 6; ++i) {
            n = 0;
            if (vector4fArray[i].x * this.xvert[0][0] + vector4fArray[i].y * this.xvert[0][1] + vector4fArray[i].z * this.xvert[0][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[1][0] + vector4fArray[i].y * this.xvert[1][1] + vector4fArray[i].z * this.xvert[1][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[2][0] + vector4fArray[i].y * this.xvert[2][1] + vector4fArray[i].z * this.xvert[2][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[3][0] + vector4fArray[i].y * this.xvert[3][1] + vector4fArray[i].z * this.xvert[3][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[4][0] + vector4fArray[i].y * this.xvert[4][1] + vector4fArray[i].z * this.xvert[4][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[5][0] + vector4fArray[i].y * this.xvert[5][1] + vector4fArray[i].z * this.xvert[5][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[6][0] + vector4fArray[i].y * this.xvert[6][1] + vector4fArray[i].z * this.xvert[6][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (vector4fArray[i].x * this.xvert[7][0] + vector4fArray[i].y * this.xvert[7][1] + vector4fArray[i].z * this.xvert[7][2] + vector4fArray[i].w > 0.0f) {
                ++n;
            }
            if (n == 0) {
                return 0;
            }
            if (n != 8) continue;
            ++n2;
        }
        return n2 == 6 ? 2 : 1;
    }

    public boolean checkIntersectionSegment(float[] fArray, float[] fArray2) {
        float f = (fArray2[0] + fArray[0]) * 0.5f - this.center[0];
        float f2 = (fArray2[1] + fArray[1]) * 0.5f - this.center[1];
        float f3 = (fArray2[2] + fArray[2]) * 0.5f - this.center[2];
        float f4 = f - (fArray[0] - this.center[0]);
        float f5 = f2 - (fArray[1] - this.center[1]);
        float f6 = f3 - (fArray[2] - this.center[2]);
        float f7 = f4 > 0.0f ? f4 : -f4;
        float f8 = f5 > 0.0f ? f5 : -f5;
        float f9 = f6 > 0.0f ? f6 : -f6;
        float f10 = this.size[0];
        float f11 = this.size[1];
        float f12 = this.size[2];
        return !(Math.abs(f) > f7 + f10 || Math.abs(f2) > f8 + f11 || Math.abs(f3) > f9 + f12 || Math.abs(f2 * f6 - f3 * f5) > f11 * f9 + f12 * f8 || Math.abs(f * f6 - f3 * f4) > f10 * f9 + f12 * f7) && !(Math.abs(f * f5 - f2 * f4) > f10 * f8 + f11 * f7);
    }

    public void transform(Matrix4d matrix4d) {
        this.min.x = this.center[0];
        this.min.y = this.center[1];
        this.min.z = this.center[2];
        this.max.x = this.size[0];
        this.max.y = this.size[1];
        this.max.z = this.size[2];
        matrix4d.transform(this.min);
        matrix4d.transform((Tuple4f)this.max);
        this.center[0] = this.min.x;
        this.center[1] = this.min.y;
        this.center[2] = this.min.z;
        this.size[0] = Math.abs(this.max.x);
        this.size[1] = Math.abs(this.max.y);
        this.size[2] = Math.abs(this.max.z);
        this.min.x = this.center[0] - this.size[0];
        this.min.y = this.center[1] - this.size[1];
        this.min.z = this.center[2] - this.size[2];
        this.max.x = this.center[0] + this.size[0];
        this.max.y = this.center[1] + this.size[1];
        this.max.z = this.center[2] + this.size[2];
    }

    public void transform(Matrix4f matrix4f) {
        this.min.x = this.center[0];
        this.min.y = this.center[1];
        this.min.z = this.center[2];
        this.max.x = this.size[0];
        this.max.y = this.size[1];
        this.max.z = this.size[2];
        matrix4f.transform(this.min);
        matrix4f.transform((Tuple4f)this.max);
        this.center[0] = this.min.x;
        this.center[1] = this.min.y;
        this.center[2] = this.min.z;
        this.size[0] = Math.abs(this.max.x);
        this.size[1] = Math.abs(this.max.y);
        this.size[2] = Math.abs(this.max.z);
        this.min.x = this.center[0] - this.size[0];
        this.min.y = this.center[1] - this.size[1];
        this.min.z = this.center[2] - this.size[2];
        this.max.x = this.center[0] + this.size[0];
        this.max.y = this.center[1] + this.size[1];
        this.max.z = this.center[2] + this.size[2];
    }

    public void setBounds(float[] fArray, float[] fArray2) {
        this.min.x = fArray[0];
        this.min.y = fArray[1];
        this.min.z = fArray[2];
        this.max.x = fArray2[0];
        this.max.y = fArray2[1];
        this.max.z = fArray2[2];
        this.recalcExtents();
    }

    public void setMinimum(float[] fArray) {
        this.min.x = fArray[0];
        this.min.y = fArray[1];
        this.min.z = fArray[2];
        this.recalcExtents();
    }

    public void setMinimum(float f, float f2, float f3) {
        this.min.x = f;
        this.min.y = f2;
        this.min.z = f3;
        this.recalcExtents();
    }

    public void getMinimum(float[] fArray) {
        fArray[0] = this.min.x;
        fArray[1] = this.min.y;
        fArray[2] = this.min.z;
    }

    public void setMaximum(float[] fArray) {
        this.max.x = fArray[0];
        this.max.y = fArray[1];
        this.max.z = fArray[2];
        this.recalcExtents();
    }

    public void setMaximum(float f, float f2, float f3) {
        this.max.x = f;
        this.max.y = f2;
        this.max.z = f3;
        this.recalcExtents();
    }

    public void getMaximum(float[] fArray) {
        fArray[0] = this.max.x;
        fArray[1] = this.max.y;
        fArray[2] = this.max.z;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Bounding Box: min(");
        stringBuffer.append(this.min.x);
        stringBuffer.append(' ');
        stringBuffer.append(this.min.y);
        stringBuffer.append(' ');
        stringBuffer.append(this.min.z);
        stringBuffer.append(") max(");
        stringBuffer.append(this.max.x);
        stringBuffer.append(' ');
        stringBuffer.append(this.max.y);
        stringBuffer.append(' ');
        stringBuffer.append(this.max.z);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void recalcExtents() {
        this.center[0] = (this.max.x + this.min.x) * 0.5f;
        this.center[1] = (this.max.y + this.min.y) * 0.5f;
        this.center[2] = (this.max.z + this.min.z) * 0.5f;
        this.size[0] = (this.max.x - this.min.x) * 0.5f;
        this.size[1] = (this.max.y - this.min.y) * 0.5f;
        this.size[2] = (this.max.z - this.min.z) * 0.5f;
        if (this.size[0] < 0.0f) {
            this.size[0] = -this.size[0];
        }
        if (this.size[1] < 0.0f) {
            this.size[1] = -this.size[1];
        }
        if (this.size[2] < 0.0f) {
            this.size[2] = -this.size[2];
        }
        this.vert[0][0] = this.max.x;
        this.vert[0][1] = this.max.y;
        this.vert[0][2] = this.max.z;
        this.vert[1][0] = this.max.x;
        this.vert[1][1] = this.max.y;
        this.vert[1][2] = this.min.z;
        this.vert[2][0] = this.max.x;
        this.vert[2][1] = this.min.y;
        this.vert[2][2] = this.max.z;
        this.vert[3][0] = this.max.x;
        this.vert[3][1] = this.min.y;
        this.vert[3][2] = this.min.z;
        this.vert[4][0] = this.min.x;
        this.vert[4][1] = this.max.y;
        this.vert[4][2] = this.max.z;
        this.vert[5][0] = this.min.x;
        this.vert[5][1] = this.max.y;
        this.vert[5][2] = this.min.z;
        this.vert[6][0] = this.min.x;
        this.vert[6][1] = this.min.y;
        this.vert[6][2] = this.max.z;
        this.vert[7][0] = this.min.x;
        this.vert[7][1] = this.min.y;
        this.vert[7][2] = this.min.z;
    }
}

