/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Raster;
import org.j3d.aviatrix3d.picking.NotPickableException;

public class BitmapRaster
extends Raster {
    private static final String NEG_WIDTH_MSG = "Bitmap width provided is less than or equal to zero: ";
    private static final String NEG_HEIGHT_MSG = "Bitmap height provided is less than or equal to zero: ";
    private static final String BIT_ARRAY_SIZE_ERR = "The provided array of bits is too small for the current width and height specified";
    private ByteBuffer pixelBuffer;
    private byte[] pixels;
    private float[] origin;
    private int pixelWidth;
    private int pixelHeight;
    private int byteWidth;

    public BitmapRaster(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException(NEG_WIDTH_MSG + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(NEG_HEIGHT_MSG + n2);
        }
        this.origin = new float[2];
        this.pixelWidth = n;
        this.pixelHeight = n2;
        this.byteWidth = n / 8;
        if (n % 8 != 0) {
            ++this.byteWidth;
        }
        this.pixelBuffer = ByteBuffer.allocateDirect(this.pixelHeight * this.byteWidth);
    }

    public void render(GL gL) {
        gL.glBitmap(this.pixelWidth, this.pixelHeight, this.origin[0], this.origin[1], 0.0f, 0.0f, this.pixelBuffer);
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        return false;
    }

    protected void updateBounds() {
        if (this.pixels != null) {
            super.updateBounds();
        }
    }

    protected void recomputeBounds() {
        if (this.pixels != null) {
            return;
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        if (this.bounds == null) {
            boundingBox = new BoundingBox();
            this.bounds = boundingBox;
        }
        boundingBox.setMinimum(0.0f, 0.0f, 0.0f);
        boundingBox.setMaximum(this.pixelWidth, this.pixelHeight, 0.0f);
    }

    protected void setLive(boolean bl) {
        boolean bl2 = this.alive;
        super.setLive(bl);
        if (!bl2 && bl) {
            this.recomputeBounds();
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        BitmapRaster bitmapRaster = (BitmapRaster)object;
        return this.compareTo(bitmapRaster);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitmapRaster)) {
            return false;
        }
        return this.equals((BitmapRaster)object);
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public void setBits(byte[] byArray) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (byArray == null) {
            this.pixelBuffer.clear();
            return;
        }
        if (byArray.length < this.pixelHeight * this.byteWidth) {
            throw new IllegalArgumentException(BIT_ARRAY_SIZE_ERR);
        }
        this.pixelBuffer.put(byArray, 0, this.pixelHeight * this.byteWidth);
        this.pixelBuffer.rewind();
    }

    public void setBits(byte[] byArray, int n, int n2) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException(NEG_WIDTH_MSG + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(NEG_HEIGHT_MSG + n2);
        }
        if (byArray == null) {
            this.pixelBuffer.clear();
            return;
        }
        int n3 = n / 8;
        if (n % 8 != 0) {
            ++n3;
        }
        if (byArray.length < n2 * n3) {
            throw new IllegalArgumentException(BIT_ARRAY_SIZE_ERR);
        }
        this.byteWidth = n3;
        this.pixelWidth = n;
        this.pixelHeight = n2;
        this.pixelBuffer = ByteBuffer.allocateDirect(this.pixelHeight * this.byteWidth);
        this.pixelBuffer.put(byArray, 0, this.pixelHeight * this.byteWidth);
        this.pixelBuffer.rewind();
    }

    public void getBits(byte[] byArray) {
        System.arraycopy(this.pixels, 0, byArray, 0, this.pixelHeight * this.byteWidth);
    }

    public void setOrigin(float f, float f2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.origin[0] = f;
        this.origin[1] = f2;
    }

    public void getOrigin(float[] fArray) {
        fArray[0] = this.origin[0];
        fArray[1] = this.origin[1];
    }

    public int compareTo(BitmapRaster bitmapRaster) {
        if (bitmapRaster == null) {
            return 1;
        }
        if (bitmapRaster == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(BitmapRaster bitmapRaster) {
        return bitmapRaster == this;
    }
}

