/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.BaseNode;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformHierarchy;
import org.j3d.aviatrix3d.rendering.BoundingVolume;

public abstract class BaseGroup
extends BaseNode
implements TransformHierarchy {
    private static final String CHILD_IDX_ERR = "Index provided > last valid index";
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    protected Node[] childList = new Node[5];
    protected int lastChild = 0;
    protected int dirtyBoundsCount = 0;
    protected float[] wkVec1 = new float[3];
    protected float[] wkVec2 = new float[3];

    protected BaseGroup() {
    }

    public void setBounds(BoundingVolume boundingVolume) {
        super.setBounds(boundingVolume);
        this.dirtyBoundsCount = 0;
    }

    protected void markBoundsDirty() {
        if (this.dirtyBoundsCount < this.lastChild) {
            ++this.dirtyBoundsCount;
        }
        if (this.parent != null && this.implicitBounds && this.dirtyBoundsCount == 1) {
            this.parent.markBoundsDirty();
        }
    }

    protected void updateBounds() {
        if (this.dirtyBoundsCount > 1) {
            --this.dirtyBoundsCount;
            return;
        }
        if (!this.implicitBounds) {
            return;
        }
        if (this.lastChild == 0) {
            this.bounds = INVALID_BOUNDS;
        } else {
            this.recomputeBounds();
        }
        this.dirtyBoundsCount = 0;
        if (this.parent != null) {
            this.parent.updateBounds();
        }
    }

    protected void recomputeBounds() {
        int n;
        if (!this.implicitBounds) {
            return;
        }
        if (this.lastChild == 0) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        BoundingVolume boundingVolume = null;
        for (n = 0; n < this.lastChild && (this.childList[n] == null || (boundingVolume = this.childList[n].getBounds()) instanceof BoundingVoid); ++n) {
        }
        if (n == this.lastChild) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        boundingVolume.getExtents(this.wkVec1, this.wkVec2);
        float f = this.wkVec1[0];
        float f2 = this.wkVec1[1];
        float f3 = this.wkVec1[2];
        float f4 = this.wkVec2[0];
        float f5 = this.wkVec2[1];
        float f6 = this.wkVec2[2];
        for (int i = n; i < this.lastChild; ++i) {
            if (this.childList[i] == null || (boundingVolume = this.childList[i].getBounds()) instanceof BoundingVoid) continue;
            boundingVolume.getExtents(this.wkVec1, this.wkVec2);
            if (this.wkVec1[0] < f) {
                f = this.wkVec1[0];
            }
            if (this.wkVec1[1] < f2) {
                f2 = this.wkVec1[1];
            }
            if (this.wkVec1[2] < f3) {
                f3 = this.wkVec1[2];
            }
            if (this.wkVec2[0] > f4) {
                f4 = this.wkVec2[0];
            }
            if (this.wkVec2[1] > f5) {
                f5 = this.wkVec2[1];
            }
            if (!(this.wkVec2[2] > f6)) continue;
            f6 = this.wkVec2[2];
        }
        if (this.bounds instanceof BoundingVoid || this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f4, f5, f6);
    }

    public void requestBoundsUpdate() {
        if (this.alive || this.lastChild == 0 || !this.implicitBounds) {
            return;
        }
        for (int i = 0; i < this.lastChild; ++i) {
            this.childList[i].requestBoundsUpdate();
        }
        this.recomputeBounds();
        this.dirtyBoundsCount = 0;
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setLive(bl);
        }
        super.setLive(bl);
        this.dirtyBoundsCount = 0;
    }

    public void addChild(Node node) throws AlreadyParentedException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.resizeList();
        this.childList[this.lastChild] = node;
        ++this.lastChild;
        if (node != null) {
            if (node.isLive() != this.alive) {
                node.setLive(this.alive);
            }
            node.setParent(this);
            node.setUpdateHandler(this.updateHandler);
        }
    }

    public void setChild(Node node, int n) throws AlreadyParentedException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        if (this.childList[n] != null) {
            this.childList[n].setLive(false);
            this.childList[n].removeParent(this);
        }
        this.childList[n] = node;
        if (node != null) {
            if (node.isLive() != this.alive) {
                node.setLive(this.alive);
            }
            node.setParent(this);
            node.setUpdateHandler(this.updateHandler);
        }
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        if (this.childList[n] != null) {
            this.childList[n].setLive(false);
            this.childList[n].removeParent(this);
        }
        System.arraycopy(this.childList, n + 1, this.childList, n, this.lastChild - n);
        --this.lastChild;
    }

    public Node getChild(int n) {
        if (n < 0 || n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        return this.childList[n];
    }

    public Node[] getAllChildren() {
        return this.childList;
    }

    public int numChildren() {
        return this.lastChild;
    }

    public int indexOfChild(Node node) {
        for (int i = 0; i < this.lastChild; ++i) {
            if (node != this.childList[i]) continue;
            return i;
        }
        return -1;
    }

    public void removeChild(Node node) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = this.indexOfChild(node);
        if (n == -1) {
            return;
        }
        this.removeChild(n);
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setLive(false);
            this.childList[i].removeParent(this);
            this.childList[i] = null;
        }
        this.lastChild = 0;
    }

    private final void resizeList() {
        if (this.lastChild + 1 == this.childList.length) {
            int n = this.childList.length;
            int n2 = n + 5;
            Node[] nodeArray = new Node[n2];
            System.arraycopy(this.childList, 0, nodeArray, 0, n);
            this.childList = nodeArray;
        }
    }
}

