/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.Sound;

public class BackgroundSound
extends Sound {
    private int source;

    public boolean isSpatialised() {
        return false;
    }

    public void render(AL aL, Matrix4f matrix4f) {
        if (this.dataChanged) {
            this.buffer = this.soundSource.getBufferId(aL, this.seq);
            if (this.buffer == -1) {
                return;
            }
            this.dataChanged = false;
            this.playChanged = true;
            this.values.rewind();
            aL.alGenSources(1, this.values);
            this.source = this.values.get(0);
            if (aL.alGetError() != 0) {
                System.out.println("Error creating OpenAL Source");
            }
            aL.alSourcei(this.source, 4105, this.buffer);
            aL.alSourcef(this.source, 4106, 1.0f);
            aL.alSource3f(this.source, 4100, 0.0f, 0.0f, 0.0f);
            aL.alSourcei(this.source, 514, 1);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            aL.alSourcef(this.source, 4099, this.pitch);
            if (aL.alGetError() != 0) {
                System.out.println("Error setting OpenAL Source params");
            }
        }
        if (this.paramsChanged) {
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            this.paramsChanged = false;
        }
        if (this.playChanged) {
            if (this.playing && this.paused) {
                aL.alSourcePlay(this.source);
            }
            if (this.playing) {
                if (this.paused) {
                    aL.alSourcePause(this.source);
                } else {
                    aL.alSourcePlay(this.source);
                }
            } else {
                aL.alSourceStop(this.source);
            }
            this.playChanged = false;
        } else if (this.playing) {
            this.values.rewind();
            aL.alGetSourcei(this.source, 4112, this.values);
            if (this.values.get(0) == 4116) {
                this.playing = false;
            }
        }
    }

    public void postRender(AL aL) {
    }

    public int compareTo(Object object) throws ClassCastException {
        BackgroundSound backgroundSound = (BackgroundSound)object;
        return this.compareTo(backgroundSound);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BackgroundSound)) {
            return false;
        }
        return this.equals((BackgroundSound)object);
    }

    public int compareTo(BackgroundSound backgroundSound) {
        if (backgroundSound == null) {
            return 1;
        }
        if (backgroundSound == this) {
            return 0;
        }
        return super.compareTo(backgroundSound);
    }

    public boolean equals(BackgroundSound backgroundSound) {
        if (backgroundSound == this) {
            return true;
        }
        if (backgroundSound == null) {
            return false;
        }
        return super.equals(backgroundSound);
    }
}

