/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.rendering.BackgroundRenderable;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.EnvironmentCullable;
import org.j3d.aviatrix3d.rendering.Renderable;

public abstract class Background
extends Leaf
implements BackgroundRenderable,
EnvironmentCullable {
    private static final String INVALID_SIZE_ERR = "The provided colour array is too short. It must be at least length 3";
    protected float[] color = new float[4];
    protected HashMap dispListMap;
    protected boolean useClearColor = true;

    protected Background() {
        this(null);
    }

    protected Background(float[] fArray) {
        this.updateColor(fArray);
    }

    public Cullable getCullableParent() {
        return this.parent instanceof Cullable ? (Cullable)((Object)this.parent) : null;
    }

    public Renderable getRenderable() {
        return this;
    }

    protected void markBoundsDirty() {
    }

    public void setColorClearEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useClearColor = bl;
    }

    public boolean isColorClearEnabled() {
        return this.useClearColor;
    }

    public void setColor(float[] fArray) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.updateColor(fArray);
    }

    public void setColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.color[0];
        fArray[1] = this.color[1];
        fArray[2] = this.color[2];
        fArray[3] = this.color[3];
    }

    private void updateColor(float[] fArray) throws IllegalArgumentException {
        if (fArray != null) {
            switch (fArray.length) {
                case 0: 
                case 1: 
                case 2: {
                    throw new IllegalArgumentException(INVALID_SIZE_ERR);
                }
                case 3: {
                    this.color[0] = fArray[0];
                    this.color[1] = fArray[1];
                    this.color[2] = fArray[2];
                    this.color[3] = 0.0f;
                    break;
                }
                case 4: {
                    this.color[0] = fArray[0];
                    this.color[1] = fArray[1];
                    this.color[2] = fArray[2];
                    this.color[3] = fArray[3];
                }
            }
        } else {
            this.color[0] = 0.0f;
            this.color[1] = 0.0f;
            this.color[2] = 0.0f;
            this.color[3] = 0.0f;
        }
    }

    protected int compareColor4(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        return 0;
    }

    protected boolean equalsColor4(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2] && fArray[3] == fArray2[3];
    }
}

