/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BlendAttributes;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.DepthAttributes;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shader;
import org.j3d.aviatrix3d.StencilAttributes;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.rendering.AppearanceAttributeRenderable;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.ShaderRenderable;
import org.j3d.aviatrix3d.rendering.TextureRenderable;

public class Appearance
extends NodeComponent
implements AppearanceRenderable {
    private static final Integer[] TEX_IDS = new Integer[32];
    private static final Integer SINGLE_TEXTURE;
    private Material material;
    private TextureUnit[] textureUnits;
    private int numTextures;
    private Shader shader;
    private PolygonAttributes polyAttr;
    private LineAttributes lineAttr;
    private PointAttributes pointAttr;
    private BlendAttributes blendAttr;
    private DepthAttributes depthAttr;
    private StencilAttributes stencilAttr;
    private boolean visible = true;

    public boolean hasTransparency() {
        if (this.blendAttr != null || this.shader != null) {
            return false;
        }
        if (this.material != null && this.material.getTransparency() != 1.0f) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.numTextures && !bl; ++i) {
            Texture texture = this.textureUnits[i].getTexture();
            if (texture == null) continue;
            switch (texture.getFormat()) {
                case 6406: 
                case 6408: 
                case 6410: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public AppearanceAttributeRenderable getAttributeRenderable(int n) {
        switch (n) {
            case 1: {
                return this.blendAttr;
            }
            case 2: {
                return this.depthAttr;
            }
            case 3: {
                return this.lineAttr;
            }
            case 4: {
                return this.pointAttr;
            }
            case 5: {
                return this.polyAttr;
            }
            case 6: {
                return this.stencilAttr;
            }
        }
        return null;
    }

    public int numTextureRenderables() {
        return this.numTextures;
    }

    public TextureRenderable getTextureRenderable(int n) {
        if (n < 0 || n >= this.numTextures) {
            return null;
        }
        return this.textureUnits[n];
    }

    public ShaderRenderable getShaderRenderable() {
        return this.shader;
    }

    public ObjectRenderable getMaterialRenderable() {
        return this.material;
    }

    public void render(GL gL) {
        if (this.numTextures == 1) {
            gL.glPushAttrib(262144);
            this.textureUnits[0].render(gL, SINGLE_TEXTURE);
        } else if (this.numTextures > 1) {
            gL.glPushAttrib(262144);
            for (int i = 0; i < this.numTextures; ++i) {
                this.textureUnits[i].render(gL, TEX_IDS[i]);
            }
        }
        if (this.blendAttr != null) {
            this.blendAttr.render(gL);
        }
        if (this.polyAttr != null) {
            this.polyAttr.render(gL);
        }
        if (this.lineAttr != null) {
            this.lineAttr.render(gL);
        }
        if (this.pointAttr != null) {
            this.pointAttr.render(gL);
        }
        if (this.depthAttr != null) {
            this.depthAttr.render(gL);
        }
        if (this.stencilAttr != null) {
            this.stencilAttr.render(gL);
        }
        if (this.material != null) {
            gL.glPushAttrib(64);
            this.material.render(gL);
        }
        if (this.shader != null) {
            this.shader.render(gL);
        }
    }

    public void postRender(GL gL) {
        if (this.shader != null) {
            this.shader.postRender(gL);
        }
        if (this.material != null) {
            this.material.postRender(gL);
            gL.glPopAttrib();
        }
        if (this.pointAttr != null) {
            this.pointAttr.postRender(gL);
        }
        if (this.lineAttr != null) {
            this.lineAttr.postRender(gL);
        }
        if (this.polyAttr != null) {
            this.polyAttr.postRender(gL);
        }
        if (this.blendAttr != null) {
            this.blendAttr.postRender(gL);
        }
        if (this.depthAttr != null) {
            this.depthAttr.postRender(gL);
        }
        if (this.stencilAttr != null) {
            this.stencilAttr.postRender(gL);
        }
        if (this.numTextures == 1) {
            this.textureUnits[0].postRender(gL, SINGLE_TEXTURE);
            gL.glPopAttrib();
        } else if (this.numTextures > 1) {
            for (int i = this.numTextures - 1; i >= 0; --i) {
                this.textureUnits[i].postRender(gL, TEX_IDS[i]);
            }
            gL.glPopAttrib();
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.material != null) {
            this.material.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.blendAttr != null) {
            this.blendAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.polyAttr != null) {
            this.polyAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.lineAttr != null) {
            this.lineAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.pointAttr != null) {
            this.pointAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.depthAttr != null) {
            this.depthAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.stencilAttr != null) {
            this.stencilAttr.setUpdateHandler(nodeUpdateHandler);
        }
        for (int i = 0; i < this.numTextures; ++i) {
            this.textureUnits[i].setUpdateHandler(nodeUpdateHandler);
        }
        if (this.shader != null) {
            this.shader.setUpdateHandler(this.updateHandler);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.numTextures != 0) {
                for (int i = 0; i < this.numTextures; ++i) {
                    this.textureUnits[i].setLive(bl);
                }
            }
            if (this.polyAttr != null) {
                this.polyAttr.setLive(bl);
            }
            if (this.lineAttr != null) {
                this.lineAttr.setLive(bl);
            }
            if (this.pointAttr != null) {
                this.pointAttr.setLive(bl);
            }
            if (this.blendAttr != null) {
                this.blendAttr.setLive(bl);
            }
            if (this.depthAttr != null) {
                this.depthAttr.setLive(bl);
            }
            if (this.stencilAttr != null) {
                this.stencilAttr.setLive(bl);
            }
            if (this.material != null) {
                this.material.setLive(bl);
            }
            if (this.shader != null) {
                this.shader.setLive(bl);
            }
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.numTextures; ++i) {
            this.textureUnits[i].checkForCyclicChild(sceneGraphObject);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        Appearance appearance = (Appearance)object;
        return this.compareTo(appearance);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Appearance)) {
            return false;
        }
        return this.equals((Appearance)object);
    }

    public void setVisible(boolean bl) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setMaterial(Material material) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.material != null) {
            this.material.setLive(false);
        }
        this.material = material;
        if (this.material != null) {
            this.material.setUpdateHandler(this.updateHandler);
            this.material.setLive(this.alive);
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setPolygonAttributes(PolygonAttributes polygonAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.polyAttr != null) {
            this.polyAttr.setLive(false);
        }
        this.polyAttr = polygonAttributes;
        if (this.polyAttr != null) {
            this.polyAttr.setUpdateHandler(this.updateHandler);
            this.polyAttr.setLive(this.alive);
        }
    }

    public PolygonAttributes getPolygonAttributes() {
        return this.polyAttr;
    }

    public void setLineAttributes(LineAttributes lineAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.lineAttr != null) {
            this.lineAttr.setLive(false);
        }
        this.lineAttr = lineAttributes;
        if (this.lineAttr != null) {
            this.lineAttr.setUpdateHandler(this.updateHandler);
            this.lineAttr.setLive(this.alive);
        }
    }

    public LineAttributes getLineAttributes() {
        return this.lineAttr;
    }

    public void setPointAttributes(PointAttributes pointAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.pointAttr != null) {
            this.pointAttr.setLive(false);
        }
        this.pointAttr = pointAttributes;
        if (this.pointAttr != null) {
            this.pointAttr.setUpdateHandler(this.updateHandler);
            this.pointAttr.setLive(this.alive);
        }
    }

    public PointAttributes getPointAttributes() {
        return this.pointAttr;
    }

    public void setBlendAttributes(BlendAttributes blendAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.blendAttr != null) {
            this.blendAttr.setLive(false);
        }
        this.blendAttr = blendAttributes;
        if (this.blendAttr != null) {
            this.blendAttr.setUpdateHandler(this.updateHandler);
            this.blendAttr.setLive(this.alive);
        }
    }

    public BlendAttributes getBlendAttributes() {
        return this.blendAttr;
    }

    public void setDepthAttributes(DepthAttributes depthAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.depthAttr != null) {
            this.depthAttr.setLive(false);
        }
        this.depthAttr = depthAttributes;
        if (this.depthAttr != null) {
            this.depthAttr.setUpdateHandler(this.updateHandler);
            this.depthAttr.setLive(this.alive);
        }
    }

    public DepthAttributes getDepthAttributes() {
        return this.depthAttr;
    }

    public void setStencilAttributes(StencilAttributes stencilAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.stencilAttr != null) {
            this.stencilAttr.setLive(false);
        }
        this.stencilAttr = stencilAttributes;
        if (this.stencilAttr != null) {
            this.stencilAttr.setUpdateHandler(this.updateHandler);
            this.stencilAttr.setLive(this.alive);
        }
    }

    public StencilAttributes getStencilAttributes() {
        return this.stencilAttr;
    }

    public void setShader(Shader shader) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.shader != null) {
            this.shader.setLive(false);
        }
        this.shader = shader;
        if (this.shader != null) {
            this.shader.setUpdateHandler(this.updateHandler);
            this.shader.setLive(this.alive);
        }
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setTextureUnits(TextureUnit[] textureUnitArray, int n) throws InvalidWriteTimingException {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.textureUnits == null || this.textureUnits.length < n) {
            this.textureUnits = new TextureUnit[n];
        }
        for (n2 = this.numTextures; n2 < n; ++n2) {
            this.textureUnits[n2] = null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.textureUnits[n2] = textureUnitArray[n2];
            this.textureUnits[n2].setUpdateHandler(this.updateHandler);
        }
        this.numTextures = n;
    }

    public int numTextureUnits() {
        return this.numTextures;
    }

    public void getTextureUnits(TextureUnit[] textureUnitArray) {
        if (textureUnitArray.length < this.numTextures) {
            throw new IllegalArgumentException("Array size is too small");
        }
        for (int i = 0; i < this.numTextures; ++i) {
            textureUnitArray[i] = this.textureUnits[i];
        }
    }

    public int compareTo(Appearance appearance) {
        int n;
        if (appearance == null) {
            return 1;
        }
        if (appearance == this) {
            return 0;
        }
        if (this.visible != appearance.visible) {
            return this.visible ? 1 : -1;
        }
        if (this.material != appearance.material) {
            if (this.material == null) {
                return -1;
            }
            if (appearance.material == null) {
                return 1;
            }
            n = this.material.compareTo(appearance.material);
            if (n != 0) {
                return n;
            }
        }
        if (this.numTextures != appearance.numTextures) {
            return this.numTextures < appearance.numTextures ? -1 : 1;
        }
        for (n = 0; n < this.numTextures; ++n) {
            if (this.textureUnits[n] == appearance.textureUnits[n]) continue;
            if (this.textureUnits[n] == null) {
                return -1;
            }
            if (appearance.textureUnits[n] == null) {
                return 1;
            }
            int n2 = this.textureUnits[n].compareTo(appearance.textureUnits[n]);
            if (n2 == 0) continue;
            return n2;
        }
        if (this.polyAttr != appearance.polyAttr) {
            if (this.polyAttr == null) {
                return -1;
            }
            if (appearance.polyAttr == null) {
                return 1;
            }
            n = this.polyAttr.compareTo(appearance.polyAttr);
            if (n != 0) {
                return n;
            }
        }
        if (this.lineAttr != appearance.lineAttr) {
            if (this.lineAttr == null) {
                return -1;
            }
            if (appearance.lineAttr == null) {
                return 1;
            }
            n = this.lineAttr.compareTo(appearance.lineAttr);
            if (n != 0) {
                return n;
            }
        }
        if (this.pointAttr != appearance.pointAttr) {
            if (this.pointAttr == null) {
                return -1;
            }
            if (appearance.pointAttr == null) {
                return 1;
            }
            n = this.pointAttr.compareTo(appearance.pointAttr);
            if (n != 0) {
                return n;
            }
        }
        if (this.blendAttr != appearance.blendAttr) {
            if (this.blendAttr == null) {
                return -1;
            }
            if (appearance.blendAttr == null) {
                return 1;
            }
            n = this.blendAttr.compareTo(appearance.blendAttr);
            if (n != 0) {
                return n;
            }
        }
        if (this.shader != appearance.shader) {
            if (this.shader == null) {
                return -1;
            }
            if (appearance.shader == null) {
                return 1;
            }
            n = this.shader.compareTo(appearance.shader);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public boolean equals(Appearance appearance) {
        if (appearance == this) {
            return true;
        }
        if (appearance == null) {
            return false;
        }
        if (this.visible != appearance.visible || this.numTextures != appearance.numTextures) {
            return false;
        }
        if (!(this.material == appearance.material || this.material != null && this.material.equals(appearance.material))) {
            return false;
        }
        for (int i = 0; i < this.numTextures; ++i) {
            if (this.textureUnits[i] == appearance.textureUnits[i] || this.textureUnits[i] != null && this.textureUnits[i].equals(appearance.textureUnits[i])) continue;
            return false;
        }
        if (!(this.polyAttr == appearance.polyAttr || this.polyAttr != null && this.polyAttr.equals(appearance.polyAttr))) {
            return false;
        }
        if (!(this.lineAttr == appearance.lineAttr || this.lineAttr != null && this.lineAttr.equals(appearance.lineAttr))) {
            return false;
        }
        if (!(this.pointAttr == appearance.pointAttr || this.pointAttr != null && this.pointAttr.equals(appearance.pointAttr))) {
            return false;
        }
        if (!(this.blendAttr == appearance.blendAttr || this.blendAttr != null && this.blendAttr.equals(appearance.blendAttr))) {
            return false;
        }
        return this.shader == appearance.shader || this.shader != null && this.shader.equals(appearance.shader);
    }

    static {
        for (int i = 0; i < 32; ++i) {
            Appearance.TEX_IDS[i] = new Integer(33984 + i);
        }
        SINGLE_TEXTURE = new Integer(-1);
    }
}

