/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BufferState;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;

public class AccumulationBufferState
extends BufferState
implements BufferStateRenderable {
    private static final String INVALID_FUNCTION_MSG = "The function requested is not a standard type: ";
    public static final int FUNCTION_ACCUMULATE = 256;
    public static final int FUNCTION_LOAD = 257;
    public static final int FUNCTION_ADD = 260;
    public static final int FUNCTION_MULTIPLY = 259;
    private float value = 1.0f;
    private int function = 256;
    private boolean clearState = true;
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private float alpha = 0.0f;

    public int getBufferType() {
        return 1;
    }

    public int getBufferBitMask() {
        return 512;
    }

    public boolean checkClearBufferState() {
        return this.clearState;
    }

    public void setBufferState(GL gL) {
        gL.glClearAccum(this.red, this.green, this.blue, this.alpha);
    }

    public void updateBufferState(GL gL) {
        gL.glAccum(this.function, this.value);
    }

    public void clearBufferState(GL gL) {
        gL.glAccum(258, 1.0f);
    }

    public int compareTo(Object object) throws ClassCastException {
        AccumulationBufferState accumulationBufferState = (AccumulationBufferState)object;
        return this.compareTo(accumulationBufferState);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccumulationBufferState)) {
            return false;
        }
        return this.equals((AccumulationBufferState)object);
    }

    public void setClearBufferState(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearState = bl;
    }

    public void setAccumFunction(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 256: 
            case 257: 
            case 259: 
            case 260: {
                this.function = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_FUNCTION_MSG + n);
            }
        }
    }

    public int getAccumFunction() {
        return this.function;
    }

    public void setValue(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.value = f;
    }

    public float getValue() {
        return this.value;
    }

    public void setClearColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.red = f;
        this.green = f2;
        this.blue = f3;
        this.alpha = f4;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int compareTo(AccumulationBufferState accumulationBufferState) {
        if (accumulationBufferState == null) {
            return 1;
        }
        if (accumulationBufferState == this) {
            return 0;
        }
        if (this.clearState != accumulationBufferState.clearState) {
            return this.clearState ? 1 : -1;
        }
        if (this.function != accumulationBufferState.function) {
            return this.function < accumulationBufferState.function ? -1 : 1;
        }
        if (this.value != accumulationBufferState.value) {
            return this.value < accumulationBufferState.value ? -1 : 1;
        }
        if (this.red != accumulationBufferState.red) {
            return this.red < accumulationBufferState.red ? -1 : 1;
        }
        if (this.green != accumulationBufferState.green) {
            return this.green < accumulationBufferState.green ? -1 : 1;
        }
        if (this.blue != accumulationBufferState.blue) {
            return this.blue < accumulationBufferState.blue ? -1 : 1;
        }
        if (this.alpha != accumulationBufferState.alpha) {
            return this.alpha < accumulationBufferState.alpha ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(AccumulationBufferState accumulationBufferState) {
        if (accumulationBufferState == this) {
            return true;
        }
        return accumulationBufferState != null && this.clearState == accumulationBufferState.clearState && this.function == accumulationBufferState.function && this.value == accumulationBufferState.value && this.red == accumulationBufferState.red && this.green == accumulationBufferState.green && this.blue == accumulationBufferState.blue && this.alpha == accumulationBufferState.alpha;
    }
}

