/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CIHashtable;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;

public class HTTPResponse
implements HTTPClientModuleConstants {
    private HTTPClientModule[] modules;
    private int timeout;
    private Request request;
    Response response;
    private HttpOutputStream out_stream;
    private InputStream inp_stream;
    private int StatusCode;
    private String ReasonLine;
    private String Version;
    private URI OriginalURI;
    private URI EffectiveURI;
    private CIHashtable Headers;
    private CIHashtable Trailers;
    private int ContentLength = -1;
    private byte[] Data;
    private boolean initialized = false;
    private boolean got_trailers = false;
    private boolean aborted = false;
    private boolean retry = false;
    private String method;
    private boolean handle_trailers = false;
    private boolean trailers_handled = false;

    HTTPResponse(HTTPClientModule[] modules, int timeout, Request orig) {
        this.modules = modules;
        this.timeout = timeout;
        try {
            int qp = orig.getRequestURI().indexOf(63);
            this.OriginalURI = new URI(orig.getConnection().getProtocol(), null, orig.getConnection().getHost(), orig.getConnection().getPort(), qp < 0 ? orig.getRequestURI() : orig.getRequestURI().substring(0, qp), qp < 0 ? null : orig.getRequestURI().substring(qp + 1), null);
        }
        catch (ParseException parseException) {}
        this.method = orig.getMethod();
    }

    void set(Request req, Response resp) {
        this.request = req;
        this.response = resp;
        resp.http_resp = this;
        resp.timeout = this.timeout;
        this.aborted = resp.final_resp;
    }

    void set(Request req, HttpOutputStream out_stream) {
        this.request = req;
        this.out_stream = out_stream;
    }

    public final int getStatusCode() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Version;
    }

    public final String getServer() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.getHeader("Server");
    }

    public final URI getOriginalURI() {
        return this.OriginalURI;
    }

    public final URL getEffectiveURL() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI.toURL();
        }
        return null;
    }

    public final URI getEffectiveURI() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI;
        }
        return this.OriginalURI;
    }

    public String getHeader(String hdr) throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return (String)this.Headers.get(hdr.trim());
    }

    public int getHeaderAsInt(String hdr) throws IOException, ModuleException, NumberFormatException {
        String val = this.getHeader(hdr);
        if (val == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(val);
    }

    public Date getHeaderAsDate(String hdr) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String raw_date = this.getHeader(hdr);
        if (raw_date == null) {
            return null;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1 && raw_date.indexOf(32) > 0) {
            raw_date = String.valueOf(raw_date) + " GMT";
        }
        try {
            date = Util.parseHttpDate(raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong(raw_date);
            }
            catch (NumberFormatException numberFormatException) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public Enumeration listHeaders() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Headers.keys();
    }

    public String getTrailer(String trailer) throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(trailer.trim());
    }

    public int getTrailerAsInt(String trailer) throws IOException, ModuleException, NumberFormatException {
        String val = this.getTrailer(trailer);
        if (val == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(val);
    }

    public Date getTrailerAsDate(String trailer) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String raw_date = this.getTrailer(trailer);
        if (raw_date == null) {
            return null;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1 && raw_date.indexOf(32) > 0) {
            raw_date = String.valueOf(raw_date) + " GMT";
        }
        try {
            date = Util.parseHttpDate(raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong(raw_date);
            }
            catch (NumberFormatException numberFormatException) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public Enumeration listTrailers() throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return this.Trailers.keys();
    }

    public synchronized byte[] getData() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException ie) {
                throw ie;
            }
            catch (IOException ioe) {
                Log.write(2, "HResp: (\"" + this.method + " " + this.OriginalURI.getPathAndQuery() + "\")");
                Log.write(2, "       ", ioe);
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {}
                throw ioe;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized String getText() throws IOException, ModuleException, ParseException {
        String ct = this.getHeader("Content-Type");
        if (ct == null || !ct.toLowerCase().startsWith("text/")) {
            throw new IOException("Content-Type `" + ct + "' is not a text type");
        }
        String charset = Util.getParameter("charset", ct);
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return new String(this.getData(), charset);
    }

    public synchronized InputStream getInputStream() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        this.getData();
        return new ByteArrayInputStream(this.Data);
    }

    public boolean retryRequest() throws IOException, ModuleException {
        block2: {
            if (this.initialized) break block2;
            try {
                this.handleResponse();
            }
            catch (RetryException retryException) {
                this.retry = this.response.retry;
            }
        }
        return this.retry;
    }

    public String toString() {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedIOException)) {
                    Log.write(2, "HResp: (\"" + this.method + " " + this.OriginalURI.getPathAndQuery() + "\")");
                    Log.write(2, "       ", e);
                }
                return "Failed to read headers: " + e;
            }
        }
        String nl = System.getProperty("line.separator", "\n");
        StringBuffer str = new StringBuffer(this.Version);
        str.append(' ');
        str.append(this.StatusCode);
        str.append(' ');
        str.append(this.ReasonLine);
        str.append(nl);
        if (this.EffectiveURI != null) {
            str.append("Effective-URI: ");
            str.append(this.EffectiveURI);
            str.append(nl);
        }
        Enumeration hdr_list = this.Headers.keys();
        while (hdr_list.hasMoreElements()) {
            String hdr = (String)hdr_list.nextElement();
            str.append(hdr);
            str.append(": ");
            str.append(this.Headers.get(hdr));
            str.append(nl);
        }
        return str.toString();
    }

    HTTPClientModule[] getModules() {
        return this.modules;
    }

    /*
     * Exception decompiling
     */
    synchronized boolean handleResponse() throws IOException, ModuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void init(Response resp) {
        if (this.initialized) {
            return;
        }
        this.StatusCode = resp.StatusCode;
        this.ReasonLine = resp.ReasonLine;
        this.Version = resp.Version;
        this.EffectiveURI = resp.EffectiveURI;
        this.ContentLength = resp.ContentLength;
        this.Headers = resp.Headers;
        this.inp_stream = resp.inp_stream;
        this.Data = resp.Data;
        this.retry = resp.retry;
        this.initialized = true;
    }

    void invokeTrailerHandlers(boolean force) throws IOException, ModuleException {
        if (this.trailers_handled) {
            return;
        }
        if (!force && !this.initialized) {
            this.handle_trailers = true;
            return;
        }
        int idx = 0;
        while (idx < this.modules.length && !this.aborted) {
            this.modules[idx].trailerHandler(this.response, this.request);
            ++idx;
        }
        this.trailers_handled = true;
    }

    void markAborted() {
        this.aborted = true;
    }

    private synchronized void getTrailers() throws IOException, ModuleException {
        if (this.got_trailers) {
            return;
        }
        if (!this.initialized) {
            this.handleResponse();
        }
        this.response.getTrailer("Any");
        this.Trailers = this.response.Trailers;
        this.got_trailers = true;
        this.invokeTrailerHandlers(false);
    }

    private void readResponseData(InputStream inp) throws IOException, ModuleException {
        if (this.ContentLength == 0) {
            return;
        }
        if (this.Data == null) {
            this.Data = new byte[0];
        }
        int off = this.Data.length;
        try {
            try {
                if (this.getHeader("Content-Length") != null) {
                    int rcvd = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((rcvd = inp.read(this.Data, off += rcvd, this.ContentLength - off)) != -1 && off + rcvd < this.ContentLength) {
                    }
                } else {
                    int inc = 1000;
                    int rcvd = 0;
                    do {
                        this.Data = Util.resizeArray(this.Data, (off += rcvd) + inc);
                    } while ((rcvd = inp.read(this.Data, off, inc)) != -1);
                    this.Data = Util.resizeArray(this.Data, off);
                }
            }
            catch (IOException ioe) {
                this.Data = Util.resizeArray(this.Data, off);
                throw ioe;
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {
                inp.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inp.close();
        }
        catch (IOException iOException) {}
    }

    int getTimeout() {
        return this.timeout;
    }
}

