/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.protocol;

import org.ietf.uri.URIResourceStream;
import org.ietf.uri.URIResourceStreamFactory;
import org.web3d.net.protocol.FileResourceStream;
import org.web3d.net.protocol.JarResourceStream;
import org.web3d.net.protocol.JavascriptResourceStream;
import org.web3d.util.HashSet;

public class X3DResourceFactory
implements URIResourceStreamFactory {
    private static HashSet supportedTypes = new HashSet();
    private URIResourceStreamFactory nestedFactory;

    public X3DResourceFactory(URIResourceStreamFactory uRIResourceStreamFactory) {
        this.nestedFactory = uRIResourceStreamFactory;
    }

    public URIResourceStream createURIResourceStream(String string) {
        URIResourceStream uRIResourceStream = null;
        if (supportedTypes.contains(string)) {
            switch (string.charAt(0)) {
                case 'j': {
                    uRIResourceStream = new JarResourceStream();
                    break;
                }
                case 'e': {
                    uRIResourceStream = new JavascriptResourceStream(true);
                    break;
                }
                case 'f': {
                    uRIResourceStream = new FileResourceStream();
                }
            }
        } else if (this.nestedFactory != null) {
            uRIResourceStream = this.nestedFactory.createURIResourceStream(string);
        }
        return uRIResourceStream;
    }

    static {
        supportedTypes.add("jar");
        supportedTypes.add("ecmascript");
        supportedTypes.add("file");
    }
}

