/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.protocol;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URL;
import org.web3d.util.HashSet;

class JarResourceConnection
extends ResourceConnection {
    private static final int BUFFER_SIZE = 2048;
    public static final String JAR_CONTENT_TYPE = "x-java/jar";
    public static final String JAR_FILE_EXTENSION = "jar";
    private InputStream inputStream = null;
    private String contentType = null;
    private URI jarFileURI;
    private String jarEntryName;
    private String jarLocationHash;
    private JarFile jarFile;
    private JarEntry jarEntry;
    private static HashMap loadMutexMap;
    private static HashSet loadingSet;

    JarResourceConnection(URI uRI, String string) throws MalformedURLException {
        super(new URL("jar:" + uRI.toExternalForm() + "!/" + string));
        this.jarFileURI = uRI;
        this.jarLocationHash = Integer.toString(uRI.hashCode());
        if (string != null && string.length() != 0) {
            this.jarEntryName = string;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.inputStream == null) {
            if (this.jarFile == null) {
                this.downloadFile();
            }
            if (this.jarEntryName != null) {
                if (this.jarEntry == null) {
                    this.getJarEntry();
                }
                this.inputStream = this.jarFile.getInputStream(this.jarEntry);
            } else {
                this.inputStream = new FileInputStream(this.jarFile.getName());
            }
        }
        return this.inputStream;
    }

    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this.jarEntryName != null ? JarResourceConnection.findContentType(this.jarEntryName) : JAR_CONTENT_TYPE;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.downloadFile();
        this.connected = true;
    }

    public Attributes getAttributes() throws IOException {
        if (this.jarEntryName == null) {
            return null;
        }
        if (this.jarEntry == null) {
            this.getJarEntry();
        }
        Attributes attributes = null;
        if (this.jarEntry != null) {
            attributes = this.jarEntry.getAttributes();
        }
        return attributes;
    }

    public Certificate[] getCertificates() throws IOException {
        if (this.jarEntryName == null) {
            return null;
        }
        if (this.jarEntry == null) {
            this.getJarEntry();
        }
        Certificate[] certificateArray = null;
        if (this.jarEntry != null) {
            certificateArray = this.jarEntry.getCertificates();
        }
        return certificateArray;
    }

    public String getEntryName() {
        return this.jarEntryName;
    }

    public JarEntry getJarEntry() throws IOException {
        if (this.jarEntryName == null) {
            return null;
        }
        if (this.jarEntry == null) {
            if (this.jarFile == null) {
                this.downloadFile();
            }
            this.jarEntry = this.jarFile.getJarEntry(this.jarEntryName);
            if (this.jarEntry == null) {
                throw new FileNotFoundException(this.jarEntryName + " entry not found in the JAR file");
            }
        }
        return this.jarEntry;
    }

    public URI getJarFileURI() {
        return this.jarFileURI;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        Attributes attributes = null;
        if (manifest != null) {
            attributes = manifest.getMainAttributes();
        }
        return attributes;
    }

    public Manifest getManifest() throws IOException {
        if (this.jarFile == null) {
            this.downloadFile();
        }
        return this.jarFile.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile() throws IOException {
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string, this.jarLocationHash + ".jar");
        file.deleteOnExit();
        Object object = loadMutexMap.get(this.jarLocationHash);
        if (object == null) {
            object = new Object();
            loadMutexMap.put(this.jarLocationHash, object);
        }
        Object v = object;
        synchronized (v) {
            if (loadingSet.contains(this.jarLocationHash)) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ResourceConnection resourceConnection = this.jarFileURI.getResource();
            if (file.exists() && file.lastModified() > resourceConnection.getLastModified()) {
                if (this.jarFile == null) {
                    this.jarFile = new JarFile(file);
                }
                return;
            }
            loadingSet.add(this.jarLocationHash);
            try {
                int n;
                resourceConnection.connect();
                InputStream inputStream = resourceConnection.getInputStream();
                BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                byte[] byArray = new byte[2048];
                boolean bl = false;
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
                bufferedOutputStream.close();
                this.jarFile = new JarFile(file);
            }
            finally {
                loadingSet.remove(this.jarLocationHash);
                loadMutexMap.remove(this.jarLocationHash);
                object.notifyAll();
            }
        }
    }

    static {
        JarResourceConnection.addContentTypeToDefaultMap(JAR_CONTENT_TYPE, JAR_FILE_EXTENSION);
        loadMutexMap = new HashMap();
        loadingSet = new HashSet();
    }
}

