/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.protocol;

import java.net.MalformedURLException;
import java.util.HashSet;

class FileResourceConnection
extends vlc.net.protocol.file.FileResourceConnection {
    private static final HashSet X3D_GZIP_TYPES;
    private static final HashSet NONSTANDARD_TYPES;
    private String encoding;
    private String contentType;

    FileResourceConnection(String string) throws MalformedURLException {
        super(string);
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        String string = super.getContentType();
        if (!NONSTANDARD_TYPES.contains(string)) {
            this.contentType = string;
            return this.contentType;
        }
        int n = this.path.lastIndexOf(".");
        if (string.equals("application/x-gzip")) {
            String string2 = this.path.substring(0, n);
            String string3 = FileResourceConnection.findContentType((String)string2);
            if (string3 != null) {
                this.encoding = "x-gzip";
                this.contentType = string3;
            }
        } else {
            String string4 = this.path.substring(n + 1);
            if (X3D_GZIP_TYPES.contains(string4)) {
                this.encoding = "x-gzip";
            }
            this.contentType = string;
        }
        return this.contentType;
    }

    public String getContentEncoding() {
        if (this.encoding == null && this.contentType == null) {
            this.getContentType();
        }
        return this.encoding;
    }

    static {
        NONSTANDARD_TYPES = new HashSet();
        NONSTANDARD_TYPES.add("application/x-gzip");
        NONSTANDARD_TYPES.add("model/x3d+vrml");
        NONSTANDARD_TYPES.add("model/x3d+xml");
        X3D_GZIP_TYPES = new HashSet();
        X3D_GZIP_TYPES.add("x3dvz");
        X3D_GZIP_TYPES.add("x3dz");
    }
}

