/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.content;

import org.ietf.uri.ContentHandler;
import org.ietf.uri.ContentHandlerFactory;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.AudioContentHandler;
import org.web3d.net.content.JavascriptContentHandler;
import org.web3d.net.content.MovieContentHandler;
import org.web3d.net.content.Utf8ContentHandler;
import org.web3d.util.HashSet;
import org.xj3d.core.loading.WorldLoaderManager;

public class VRMLContentHandlerFactory
implements ContentHandlerFactory {
    private static final HashSet UTF8_TYPES = new HashSet();
    private static final HashSet XML_TYPES;
    private static final HashSet BINARY_TYPES;
    private static final HashSet ECMASCRIPT_TYPES;
    private static final HashSet AUDIO_TYPES;
    private static final HashSet MOVIE_TYPES;
    private ContentHandlerFactory nextFactory;
    private WorldLoaderManager worldLoader;
    private BrowserCore core;

    public VRMLContentHandlerFactory(BrowserCore browserCore, WorldLoaderManager worldLoaderManager) {
        this(browserCore, worldLoaderManager, null);
    }

    public VRMLContentHandlerFactory(BrowserCore browserCore, WorldLoaderManager worldLoaderManager, ContentHandlerFactory contentHandlerFactory) {
        this.nextFactory = contentHandlerFactory;
        this.core = browserCore;
        this.worldLoader = worldLoaderManager;
    }

    public ContentHandler createContentHandler(String string) {
        ContentHandler contentHandler = null;
        if (UTF8_TYPES.contains(string)) {
            contentHandler = new Utf8ContentHandler(this.core, this.worldLoader);
        } else if (XML_TYPES.contains(string)) {
            contentHandler = new Utf8ContentHandler(this.core, this.worldLoader);
        } else if (BINARY_TYPES.contains(string)) {
            System.out.println("***Should this be a BinaryContentHandler instead of utf8?");
            contentHandler = new Utf8ContentHandler(this.core, this.worldLoader);
        } else if (ECMASCRIPT_TYPES.contains(string)) {
            contentHandler = new JavascriptContentHandler();
        } else if (AUDIO_TYPES.contains(string)) {
            contentHandler = new AudioContentHandler();
        } else if (MOVIE_TYPES.contains(string)) {
            contentHandler = new MovieContentHandler();
        } else if (this.nextFactory != null) {
            contentHandler = this.nextFactory.createContentHandler(string);
        }
        return contentHandler;
    }

    public ContentHandlerFactory getWrappedFactory() {
        return this.nextFactory;
    }

    static {
        UTF8_TYPES.add("model/vrml");
        UTF8_TYPES.add("x-world/x-vrml");
        UTF8_TYPES.add("model/x3d+vrml");
        XML_TYPES = new HashSet();
        XML_TYPES.add("model/x3d+xml");
        BINARY_TYPES = new HashSet();
        BINARY_TYPES.add("model/x3d+binary");
        BINARY_TYPES.add("model/x3d+fastinfoset");
        ECMASCRIPT_TYPES = new HashSet();
        ECMASCRIPT_TYPES.add("application/x-javascript");
        ECMASCRIPT_TYPES.add("application/javascript");
        ECMASCRIPT_TYPES.add("application/x-ecmascript");
        ECMASCRIPT_TYPES.add("application/ecmascript");
        AUDIO_TYPES = new HashSet();
        AUDIO_TYPES.add("audio/x-wav");
        AUDIO_TYPES.add("audio/wav");
        MOVIE_TYPES = new HashSet();
        MOVIE_TYPES.add("video/mpeg");
        MOVIE_TYPES.add("video/x-mpeg");
        MOVIE_TYPES.add("video/mpeg-system");
        MOVIE_TYPES.add("video/x-mpeg-system");
    }
}

