/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.content;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.ietf.uri.ContentHandler;
import org.ietf.uri.ResourceConnection;
import org.web3d.browser.BrowserCore;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.sav.InputSource;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.io.ReadProgressListener;

class Utf8ContentHandler
extends ContentHandler
implements ReadProgressListener {
    private WorldLoaderManager worldLoader;
    private BrowserCore core;
    private long streamLength;
    private String extURL;
    private ResourceConnection resource;

    Utf8ContentHandler(BrowserCore browserCore, WorldLoaderManager worldLoaderManager) {
        this.core = browserCore;
        this.worldLoader = worldLoaderManager;
    }

    public Object getContent(ResourceConnection resourceConnection) throws IOException {
        String string;
        InputStream inputStream = resourceConnection.getInputStream();
        inputStream = new BufferedInputStream(inputStream);
        String string2 = resourceConnection.getContentEncoding();
        if (string2 != null && string2.equals("x-gzip")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if ((string = resourceConnection.getURI().toExternalForm()).startsWith("file:") && (string = string.replace('\\', '/')).charAt(7) != '\\') {
            string = "file:///" + string.substring(6);
        }
        int n = string.lastIndexOf("/");
        String string3 = string.substring(0, n + 1);
        this.streamLength = resourceConnection.getContentLength();
        InputSource inputSource = new InputSource(string3, inputStream, string);
        inputSource.setReadProgressListener(this, (int)(this.streamLength / 50L));
        inputSource.setContentType(resourceConnection.getContentType());
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        this.extURL = string;
        this.resource = resourceConnection;
        this.notifyDownloadStarted(resourceConnection, this.extURL);
        VRMLScene vRMLScene = worldLoader.loadNow(this.core, inputSource);
        this.notifyDownloadFinished(resourceConnection, this.extURL);
        this.worldLoader.releaseLoader(worldLoader);
        this.resource = null;
        return vRMLScene;
    }

    public void progressUpdate(long l) {
        this.notifyDownloadProgress(this.resource, (int)l, this.extURL);
    }

    public void streamClosed() {
    }
}

