/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.content;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.ietf.uri.ContentHandler;
import org.ietf.uri.ResourceConnection;
import org.web3d.image.AreaAveragingScaleFilter;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.util.MathUtils;
import org.web3d.util.PropertyTools;

public abstract class ImageContentHandler
extends ContentHandler {
    private static final String PREFERED_IMAGE_CLASSNAME = "vlc.image.ByteBufferImage";
    private static final String RESCALE_PROP = "org.web3d.vrml.renderer.common.nodes.shape.rescale";
    private static final int DEFAULT_RESCALE = 2;
    private static final HashMap rescaleMap;
    private static final String MAX_TEXTURE_SIZE_PROP = "org.web3d.vrml.renderer.common.nodes.shape.maxTextureSize";
    private static final int DEFAULT_MAX_TEXTURE_SIZE = -1;
    private static final String USE_MIPMAPS_PROP = "org.web3d.vrml.renderer.common.nodes.shape.useMipMaps";
    private static final boolean DEFAULT_USE_MIPMAPS = false;
    protected static final int rescale;
    protected static final boolean imageScaleUp;
    protected static final int maxTextureSize;
    protected static boolean useMipMaps;
    protected static Class image_class;

    protected ImageContentHandler() {
    }

    public abstract Object getContent(ResourceConnection var1) throws IOException;

    protected static NIOBufferImage convert(Class clazz, Object object) {
        NIOBufferImage nIOBufferImage = null;
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Method method = clazz.getMethod("getHeight", classArray);
            Method method2 = clazz.getMethod("getWidth", classArray);
            Method method3 = clazz.getMethod("getBuffer", classArray);
            Method method4 = clazz.getMethod("getType", classArray);
            Integer n = (Integer)method.invoke(object, objectArray);
            Integer n2 = (Integer)method2.invoke(object, objectArray);
            ByteBuffer byteBuffer = (ByteBuffer)method3.invoke(object, objectArray);
            Integer n3 = (Integer)method4.invoke(object, objectArray);
            nIOBufferImage = new NIOBufferImage(n2, n, NIOBufferImageType.getType(n3), byteBuffer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println(noSuchMethodException.getMessage());
        }
        catch (SecurityException securityException) {
            System.out.println(securityException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println(invocationTargetException.getMessage());
        }
        return nIOBufferImage;
    }

    protected static Class getPreferedImageClass() {
        return image_class;
    }

    protected NIOBufferImage[] preprocess(NIOBufferImage nIOBufferImage) {
        NIOBufferImage[] nIOBufferImageArray;
        int n = nIOBufferImage.getWidth();
        int n2 = nIOBufferImage.getHeight();
        int n3 = MathUtils.nearestPowerTwo(n, imageScaleUp);
        int n4 = MathUtils.nearestPowerTwo(n2, imageScaleUp);
        if (maxTextureSize > 0) {
            float f;
            if (n3 == n4) {
                if (n3 > maxTextureSize) {
                    f = (float)maxTextureSize / (float)n3;
                    n3 = (int)(f * (float)n3);
                    n4 = (int)(f * (float)n4);
                }
            } else if (n3 > n4) {
                if (n3 > maxTextureSize) {
                    f = (float)maxTextureSize / (float)n3;
                    n3 = (int)(f * (float)n3);
                    n4 = (int)(f * (float)n4);
                }
            } else if (n4 > maxTextureSize) {
                f = (float)maxTextureSize / (float)n4;
                n3 = (int)(f * (float)n3);
                n4 = (int)(f * (float)n4);
            }
        }
        AreaAveragingScaleFilter areaAveragingScaleFilter = new AreaAveragingScaleFilter(nIOBufferImage);
        if (n != n3 || n2 != n4) {
            nIOBufferImage = areaAveragingScaleFilter.getScaledImage(n3, n4);
        }
        if (useMipMaps) {
            boolean bl = false;
            int n5 = Math.max(MathUtils.computeLog(n3), MathUtils.computeLog(n4)) + 1;
            nIOBufferImageArray = new NIOBufferImage[n5];
            nIOBufferImageArray[0] = nIOBufferImage;
            for (int i = 1; i < n5; ++i) {
                if (n3 > 1) {
                    n3 >>= 1;
                }
                if (n4 > 1) {
                    n4 >>= 1;
                }
                nIOBufferImageArray[i] = areaAveragingScaleFilter.getScaledImage(n3, n4);
            }
        } else {
            nIOBufferImageArray = new NIOBufferImage[]{nIOBufferImage};
        }
        return nIOBufferImageArray;
    }

    protected NIOBufferImage consolidate(NIOBufferImage[] nIOBufferImageArray) {
        NIOBufferImage nIOBufferImage = null;
        if (nIOBufferImageArray != null && nIOBufferImageArray[0] != null) {
            nIOBufferImage = nIOBufferImageArray[0];
            int n = nIOBufferImageArray.length;
            if (n > 1) {
                ByteBuffer[] byteBufferArray = new ByteBuffer[n];
                for (int i = 0; i < n; ++i) {
                    byteBufferArray[i] = nIOBufferImageArray[i].getBuffer();
                }
                nIOBufferImage.setBuffer(byteBufferArray);
            }
        }
        return nIOBufferImage;
    }

    static {
        imageScaleUp = false;
        rescaleMap = new HashMap(2);
        rescaleMap.put("BILINEAR", new Integer(2));
        rescaleMap.put("NEAREST_NEIGBOR", new Integer(1));
        rescale = PropertyTools.fetchSystemProperty(RESCALE_PROP, 2, rescaleMap);
        int n = PropertyTools.fetchSystemProperty(MAX_TEXTURE_SIZE_PROP, -1);
        int n2 = MathUtils.nearestPowerTwo(n, false);
        if (n != -1 && n != n2) {
            System.out.println("Maximum texture size not a power of two.  Changed to: " + n2);
            maxTextureSize = n2;
        } else {
            maxTextureSize = n;
        }
        useMipMaps = PropertyTools.fetchSystemProperty(USE_MIPMAPS_PROP, false);
        try {
            Class<?> clazz = Class.forName("vlc.net.content.image.ImageDecoder");
            Object obj = clazz.newInstance();
            image_class = Class.forName(PREFERED_IMAGE_CLASSNAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

