/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionEstablishedListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.OpenTrustManager;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPConnection {
    public static boolean DEBUG_ENABLED = false;
    private static List connectionEstablishedListeners = new ArrayList();
    private SmackDebugger debugger = null;
    String host;
    int port;
    Socket socket;
    String serviceName;
    String connectionID;
    private String user = null;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private AccountManager accountManager = null;
    private SASLAuthentication saslAuthentication = new SASLAuthentication(this);
    Writer writer;
    Reader reader;
    Map chats = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$Message;
    static /* synthetic */ Class class$org$jivesoftware$smack$XMPPConnection;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$io$Reader;

    public XMPPConnection(String serviceName) throws XMPPException {
        DNSUtil.HostAddress address = DNSUtil.resolveXMPPDomain(serviceName);
        this.host = address.getHost();
        this.port = address.getPort();
        try {
            this.socket = new Socket(this.host, this.port);
        }
        catch (UnknownHostException uhe) {
            throw new XMPPException("Could not connect to " + this.host + ":" + this.port + ".", new XMPPError(504), uhe);
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError connecting to " + this.host + ":" + this.port + ".", new XMPPError(502), ioe);
        }
        this.serviceName = serviceName;
        this.init();
    }

    public XMPPConnection(String host, int port) throws XMPPException {
        this.host = host;
        this.port = port;
        try {
            this.socket = new Socket(host, port);
        }
        catch (UnknownHostException uhe) {
            throw new XMPPException("Could not connect to " + host + ":" + port + ".", new XMPPError(504), uhe);
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError connecting to " + host + ":" + port + ".", new XMPPError(502), ioe);
        }
        this.serviceName = host;
        this.init();
    }

    public XMPPConnection(String host, int port, String serviceName) throws XMPPException {
        this.host = host;
        this.port = port;
        try {
            this.socket = new Socket(host, port);
        }
        catch (UnknownHostException uhe) {
            throw new XMPPException("Could not connect to " + host + ":" + port + ".", new XMPPError(504), uhe);
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError connecting to " + host + ":" + port + ".", new XMPPError(502), ioe);
        }
        this.serviceName = serviceName;
        this.init();
    }

    public XMPPConnection(String host, int port, String serviceName, SocketFactory socketFactory) throws XMPPException {
        this.host = host;
        this.port = port;
        try {
            this.socket = socketFactory.createSocket(host, port);
        }
        catch (UnknownHostException uhe) {
            throw new XMPPException("Could not connect to " + host + ":" + port + ".", new XMPPError(504), uhe);
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError connecting to " + host + ":" + port + ".", new XMPPError(502), ioe);
        }
        this.serviceName = serviceName;
        this.init();
    }

    XMPPConnection() {
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void login(String username, String password) throws XMPPException {
        this.login(username, password, "Smack");
    }

    public synchronized void login(String username, String password, String resource) throws XMPPException {
        this.login(username, password, resource, true);
    }

    public synchronized void login(String username, String password, String resource, boolean sendPresence) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        username = username.toLowerCase().trim();
        String response = null;
        response = this.saslAuthentication.hasNonAnonymousAuthentication() ? this.saslAuthentication.authenticate(username, password, resource) : new NonSASLAuthentication(this).authenticate(username, password, resource);
        if (response != null) {
            this.user = response;
            this.serviceName = StringUtils.parseServer(response);
        } else {
            this.user = username + "@" + this.serviceName;
            if (resource != null) {
                this.user = this.user + "/" + resource;
            }
        }
        this.roster = new Roster(this);
        this.roster.reload();
        if (sendPresence) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.AVAILABLE));
        }
        this.authenticated = true;
        this.anonymous = false;
        if (DEBUG_ENABLED && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String response = null;
        response = this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = response;
        this.serviceName = StringUtils.parseServer(response);
        this.roster = null;
        this.packetWriter.sendPacket(new Presence(Presence.Type.AVAILABLE));
        this.authenticated = true;
        this.anonymous = true;
        if (DEBUG_ENABLED && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRoster() {
        if (this.roster == null) {
            return null;
        }
        if (!this.roster.rosterInitialized) {
            try {
                Roster roster = this.roster;
                synchronized (roster) {
                    long now;
                    long start = System.currentTimeMillis();
                    for (long waitTime = (long)SmackConfiguration.getPacketReplyTimeout(); !this.roster.rosterInitialized && waitTime > 0L; waitTime -= now - start) {
                        this.roster.wait(waitTime);
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    public synchronized AccountManager getAccountManager() {
        if (this.accountManager == null) {
            this.accountManager = new AccountManager(this);
        }
        return this.accountManager;
    }

    public Chat createChat(String participant) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        return new Chat(this, participant);
    }

    public GroupChat createGroupChat(String room) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        return new GroupChat(this, room);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void close() {
        this.packetWriter.sendPacket(new Presence(Presence.Type.UNAVAILABLE));
        this.packetReader.shutdown();
        this.packetWriter.shutdown();
        try {
            Thread.sleep(150L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.authenticated = false;
        this.connected = false;
    }

    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetReader.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.packetReader.removePacketListener(packetListener);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.packetWriter.removePacketListener(packetListener);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.packetWriter.removePacketInterceptor(packetInterceptor);
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        return this.packetReader.createPacketCollector(packetFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return;
        }
        List list = this.packetReader.connectionListeners;
        synchronized (list) {
            if (!this.packetReader.connectionListeners.contains(connectionListener)) {
                this.packetReader.connectionListeners.add(connectionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        List list = this.packetReader.connectionListeners;
        synchronized (list) {
            this.packetReader.connectionListeners.remove(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnectionListener(ConnectionEstablishedListener connectionEstablishedListener) {
        List list = connectionEstablishedListeners;
        synchronized (list) {
            if (!connectionEstablishedListeners.contains(connectionEstablishedListener)) {
                connectionEstablishedListeners.add(connectionEstablishedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionListener(ConnectionEstablishedListener connectionEstablishedListener) {
        List list = connectionEstablishedListeners;
        synchronized (list) {
            connectionEstablishedListeners.remove(connectionEstablishedListener);
        }
    }

    private void init() throws XMPPException {
        this.initReaderAndWriter();
        try {
            this.packetWriter = new PacketWriter(this);
            this.packetReader = new PacketReader(this);
            if (DEBUG_ENABLED) {
                this.packetReader.addPacketListener(this.debugger.getReaderListener(), null);
                if (this.debugger.getWriterListener() != null) {
                    this.packetWriter.addPacketListener(this.debugger.getWriterListener(), null);
                }
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            XMPPConnection.connectionEstablished(this);
            this.addPacketListener(new PacketListener(){

                public void processPacket(Packet packet) {
                    WeakReference chatRef;
                    Message message = (Message)packet;
                    if (message.getThread() == null && (chatRef = (WeakReference)XMPPConnection.this.chats.get(StringUtils.parseBareAddress(message.getFrom()))) != null) {
                        Chat chat = (Chat)chatRef.get();
                        if (chat == null) {
                            XMPPConnection.this.chats.remove(message.getFrom());
                        } else {
                            chat.deliver(message);
                        }
                    }
                }
            }, new PacketTypeFilter(class$org$jivesoftware$smack$packet$Message == null ? (class$org$jivesoftware$smack$packet$Message = XMPPConnection.class$("org.jivesoftware.smack.packet.Message")) : class$org$jivesoftware$smack$packet$Message));
        }
        catch (XMPPException ex) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            this.authenticated = false;
            this.connected = false;
            throw ex;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(502), ioe);
        }
        if (DEBUG_ENABLED) {
            if (this.debugger == null) {
                String className = null;
                try {
                    className = System.getProperty("smack.debuggerClass");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Class<?> debuggerClass = null;
                if (className != null) {
                    try {
                        debuggerClass = Class.forName(className);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (debuggerClass == null) {
                    try {
                        debuggerClass = Class.forName("org.jivesoftware.smackx.debugger.EnhancedDebugger");
                    }
                    catch (Exception ex) {
                        try {
                            debuggerClass = Class.forName("org.jivesoftware.smack.debugger.LiteDebugger");
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                try {
                    Constructor<?> constructor = debuggerClass.getConstructor(class$org$jivesoftware$smack$XMPPConnection == null ? (class$org$jivesoftware$smack$XMPPConnection = XMPPConnection.class$("org.jivesoftware.smack.XMPPConnection")) : class$org$jivesoftware$smack$XMPPConnection, class$java$io$Writer == null ? (class$java$io$Writer = XMPPConnection.class$("java.io.Writer")) : class$java$io$Writer, class$java$io$Reader == null ? (class$java$io$Reader = XMPPConnection.class$("java.io.Reader")) : class$java$io$Reader);
                    this.debugger = (SmackDebugger)constructor.newInstance(this, this.writer, this.reader);
                    this.reader = this.debugger.getReader();
                    this.writer = this.debugger.getWriter();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DEBUG_ENABLED = false;
                }
            } else {
                this.reader = this.debugger.newConnectionReader(this.reader);
                this.writer = this.debugger.newConnectionWriter(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectionEstablished(XMPPConnection connection) {
        ConnectionEstablishedListener[] listeners = null;
        List list = connectionEstablishedListeners;
        synchronized (list) {
            listeners = new ConnectionEstablishedListener[connectionEstablishedListeners.size()];
            connectionEstablishedListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].connectionEstablished(connection);
        }
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    public SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    void startTLSReceived() {
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    void proceedTLSReceived() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new OpenTrustManager()}, new SecureRandom());
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostName(), plain.getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SmackConfiguration.getVersion();
    }
}

