/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.sasl.SASLAnonymous;
import org.jivesoftware.smack.sasl.SASLMechanism;

public class SASLAuthentication
implements UserAuthentication {
    private static Map implementedMechanisms = new HashMap();
    private static List mechanismsPreferences = new ArrayList();
    private XMPPConnection connection;
    private Collection serverMechanisms = new ArrayList();
    private SASLMechanism currentMechanism = null;
    private boolean saslNegotiated = false;
    private boolean saslFailed = false;
    private boolean resourceBinded = false;
    private boolean sessionSupported = false;
    static /* synthetic */ Class class$org$jivesoftware$smack$sasl$SASLPlainMechanism;
    static /* synthetic */ Class class$org$jivesoftware$smack$SASLAuthentication;

    public static void registerSASLMechanism(int index, String name, Class mClass) {
        implementedMechanisms.put(name, mClass);
        mechanismsPreferences.add(index, name);
    }

    public static void unregisterSASLMechanism(String name) {
        implementedMechanisms.remove(name);
        mechanismsPreferences.remove(name);
    }

    public static List getRegisterSASLMechanisms() {
        ArrayList answer = new ArrayList();
        Iterator it = mechanismsPreferences.iterator();
        while (it.hasNext()) {
            answer.add(implementedMechanisms.get(it.next()));
        }
        return answer;
    }

    SASLAuthentication(XMPPConnection connection) {
        this.connection = connection;
    }

    public boolean hasAnonymousAuthentication() {
        return this.serverMechanisms.contains("ANONYMOUS");
    }

    public boolean hasNonAnonymousAuthentication() {
        if (!this.serverMechanisms.isEmpty()) {
            if (this.serverMechanisms.size() == 1) {
                return !this.hasAnonymousAuthentication();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String username, String password, String resource) throws XMPPException {
        Class selected = null;
        Iterator it = mechanismsPreferences.iterator();
        while (it.hasNext()) {
            String mechanism = (String)it.next();
            if (!implementedMechanisms.containsKey(mechanism) || !this.serverMechanisms.contains(mechanism)) continue;
            selected = (Class)implementedMechanisms.get(mechanism);
            break;
        }
        if (selected != null) {
            try {
                Constructor constructor = selected.getConstructor(class$org$jivesoftware$smack$SASLAuthentication == null ? (class$org$jivesoftware$smack$SASLAuthentication = SASLAuthentication.class$("org.jivesoftware.smack.SASLAuthentication")) : class$org$jivesoftware$smack$SASLAuthentication);
                this.currentMechanism = (SASLMechanism)constructor.newInstance(this);
                this.currentMechanism.authenticate(username, this.connection.getServiceName(), password);
                SASLAuthentication sASLAuthentication = this;
                synchronized (sASLAuthentication) {
                    if (!this.saslNegotiated && !this.saslFailed) {
                        try {
                            this.wait(30000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                if (this.saslFailed) {
                    throw new XMPPException("SASL authentication failed");
                }
                if (this.saslNegotiated) {
                    return this.bindResourceAndEstablishSession(resource);
                }
                return new NonSASLAuthentication(this.connection).authenticate(username, password, resource);
            }
            catch (XMPPException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new NonSASLAuthentication(this.connection).authenticate(username, password, resource);
            }
        }
        return new NonSASLAuthentication(this.connection).authenticate(username, password, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticateAnonymously() throws XMPPException {
        try {
            this.currentMechanism = new SASLAnonymous(this);
            this.currentMechanism.authenticate(null, null, null);
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                if (!this.saslNegotiated && !this.saslFailed) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.saslFailed) {
                throw new XMPPException("SASL authentication failed");
            }
            if (this.saslNegotiated) {
                return this.bindResourceAndEstablishSession(null);
            }
            return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        }
        catch (IOException e) {
            return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String bindResourceAndEstablishSession(String resource) throws IOException, XMPPException {
        this.connection.packetWriter.openStream();
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            if (!this.resourceBinded) {
                try {
                    this.wait(30000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        Bind bindResource = new Bind();
        bindResource.setResource(resource);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(bindResource.getPacketID()));
        this.connection.sendPacket(bindResource);
        Bind response = (Bind)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        String userJID = response.getJid();
        if (this.sessionSupported) {
            Session session = new Session();
            collector = this.connection.createPacketCollector(new PacketIDFilter(session.getPacketID()));
            this.connection.sendPacket(session);
            IQ ack = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            collector.cancel();
            if (ack == null) {
                throw new XMPPException("No response from the server.");
            }
            if (ack.getType() == IQ.Type.ERROR) {
                throw new XMPPException(ack.getError());
            }
        }
        return userJID;
    }

    void setAvailableSASLMethods(Collection mechanisms) {
        this.serverMechanisms = mechanisms;
    }

    public boolean isAuthenticated() {
        return this.saslNegotiated;
    }

    void challengeReceived(String challenge) throws IOException {
        this.currentMechanism.challengeReceived(challenge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticated() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.saslNegotiated = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.saslFailed = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindingRequired() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.resourceBinded = true;
            this.notify();
        }
    }

    public void send(String stanza) throws IOException {
        this.connection.writer.write(stanza);
        this.connection.writer.flush();
    }

    void sessionsSupported() {
        this.sessionSupported = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SASLAuthentication.registerSASLMechanism(0, "PLAIN", class$org$jivesoftware$smack$sasl$SASLPlainMechanism == null ? (class$org$jivesoftware$smack$sasl$SASLPlainMechanism = SASLAuthentication.class$("org.jivesoftware.smack.sasl.SASLPlainMechanism")) : class$org$jivesoftware$smack$sasl$SASLPlainMechanism);
    }
}

