#include <stdio.h>
#include <string.h>
#include <highgui.h>
#include <time.h>
#include "libdecodeqr/decodeqr.h"

//resolução da câmera em X e Y
const double abertura_x = .002;
const double abertura_y = .002;

double tamseg(CvPoint a, CvPoint b){
    return sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y));
}

typedef struct quadrado2d{
    double x[4], y[4];
    double area;
}quadrado2d;

typedef struct quadrado3d{
    double x[4], y[4], z[4];
}quadrado3d;

void direcao(quadrado3d *q, double *latitude, double *longitude){
	double nx, ny, nz, r;
	nx = (q->y[0] - q->y[1]) * (q->z[0] - q->z[2]) - 
			(q->z[0] - q->z[1]) * (q->y[0] - q->y[2]);
	ny = -((q->x[0] - q->x[1]) * (q->z[0] - q->z[2]) - 
			(q->z[0] - q->z[1]) * (q->x[0] - q->x[2]));
	nz = ((q->x[0] - q->x[1]) * (q->y[0] - q->y[2]) - 
			(q->y[0] - q->y[1]) * (q->x[0] - q->x[2]));
			
	if(nz < 0){
		nz = -nz;
		nx = -nx;
		ny = -ny;
	}
	//printf("%lf %lf %lf\n", nx, ny, nz);
	//*latitude = atan2( sqrt(nx * nx + ny * ny), nz) * 180.0 / M_PI;
	//*longitude = atan2(ny, nx) * 180.0 / M_PI;
	//*latitude = atan2( sqrt(nx*nx+ny*ny),nz) * 180.0 / M_PI;
	//*longitude = atan2((q->y[0] - q->y[1]) , -(q->x[0] - q->x[1])) * 180.0 / M_PI;
	
	*latitude = atan2( nx , nz) * 180.0 / M_PI;
	*longitude = atan2( ny , nz) * 180.0 / M_PI;
	
}

/* manipulacao de linha da matriz */
void eliminate(double *p, double *r, int n){
    double M = -r[0]/p[0];
    double swp;
    int i;
    for(i = 1; i < n; ++i){
        r[i] += M * p[i];
    }

}
double distancia_projetada_ao_quadrado(double x1, double x2, double y1, double y2, double z1, double z2){
    double d1 = (x1*z1 - x2*z2)*abertura_x;
    double d2 = (y1*z1 - y2*z2)*abertura_y;
    double d3 = z1 - z2;
    return (d1 * d1 + d2 * d2 + d3 * d3);
}

void quadrado2dto3d(quadrado3d *q3, quadrado2d *q2){
    double matrix[3][4];
    double lS;
    int i;
    matrix[0][0] = q2->x[0];
    matrix[0][1] = -q2->x[1];
    matrix[0][2] = q2->x[2];
    matrix[0][3] = -q2->x[3];

    matrix[1][0] = -q2->y[0];
    matrix[1][1] = q2->y[1];
    matrix[1][2] = -q2->y[2];
    matrix[1][3] = q2->y[3];

    matrix[2][0] = 1;
    matrix[2][1] = -1;
    matrix[2][2] = 1;
    matrix[2][3] = -1;
    /* triangularizacao */
    eliminate(&matrix[0][0], &matrix[1][0], 4);
    eliminate(&matrix[0][0], &matrix[2][0], 4);
    eliminate(&matrix[1][1], &matrix[2][1], 3);
    /* retrosubstituicao */
    eliminate(&matrix[2][2], &matrix[1][2], 2);
    eliminate(&matrix[2][2], &matrix[0][2], 2);
    matrix[0][3] -= matrix[0][1] * matrix[1][3] / matrix[1][1];
    matrix[0][1] = 0;

    q3->z[0] = -matrix[0][3] / matrix[0][0];
    q3->z[1] = -matrix[1][3] / matrix[1][1];
    q3->z[2] = -matrix[2][3] / matrix[2][2];
    
    /* escala */
    lS = sqrt(q2->area / distancia_projetada_ao_quadrado(q2->x[0], q2->x[1],
            q2->y[0], q2->y[1], q3->z[0], q3->z[1]));

    q3->z[0] *= lS;
    q3->z[1] *= lS;
    q3->z[2] *= lS;
    q3->z[3] = lS;

    for(i = 0; i < 4;++i){
        q3->x[i] = q2->x[i] * q3->z[i] * abertura_x;
        q3->y[i] = -(q2->y[i] * q3->z[i] * abertura_y);
    }
}
