#include <algorithm>
#include <queue>

using namespace std;

#include "camremota.hpp"
#include "robotserial.hpp"
#include "qrpox.hpp"

//#define serialport_write

//cheese coordinatess
#define QX 100
#define QY 100

#define RAD90 (M_PI/2.0)
#define RAD180 (M_PI)

int fd = 0;

int getciclosbycm(double x){
	x*=10;
	int aux[17] = {2,5,11,15,20,35,40,50,76,84,92,101,111,122,125,140,160};
	//tabela de aceleracao discreta inicial
	
	for(int i=0; i<=16; ++i) if(x<aux[i]) return i;
	
	return floor(0.5+x/9.0); //arredonda para o mais proximo usando o fator 9
}

int getciclosbyang(double ang){
	if(ang<=M_PI/4.0)
		return ceil((20*ang)/(M_PI/2)); //originalmente eh 23 WARNING
	
	else return ceil((22*ang)/(M_PI/2)); //originalmente eh 23 WARNING
}

void iniciaarduino(){
    //int baudrate = B9600;  // default
	fd = serialport_init("/dev/ttyUSB0");
    if(fd==-1) fd = serialport_init("/dev/ttyUSB1");
    if(fd==-1) fd = serialport_init("/dev/ttyUSB2");
    if(fd==-1) fd = serialport_init("/dev/ttyUSB3");
    if(fd==-1){
        puts("Conexao com o robo nao foi estabelecida");
		exit(-1);
	}
	/*for(int i=0; i<100; i++){
	    system("clear");
        printf("%d%%\n", (i+1));
        usleep(1000000);
    }*/
    usleep(1000000);
    puts("ARDUINO CARREGADO!");
}

void finalizaarduino(){
	close(fd);
}

#define CONST 2

void rotate(double ang, bool cw){
	int ccw = getciclosbyang(ang);
	printf("%c = %d = %lf graus\n", cw?'>':'<', ccw, ang*(180/M_PI));
	for(int i=0; i<ccw; i++){
		if(!cw){
			serialport_write(fd, "3");
		}
		else{
			serialport_write(fd, "4");
		}
	}
	usleep((ccw)*100000);
}

void goline(double cm){
	int cca = getciclosbycm(cm); 
	printf("- = %d = %lfcm\n", cca, cm);
	for(int i=0; i<cca; i++){
		serialport_write(fd, "2");
	}
	usleep((cca)*100000);
}

bool centralizarMarcador(double cx){
	//retorna false se nao está no centro, true se está no centro, e faz o ajuste para chegar mais próximo ao centro

	puts("CENTRALIZAR");
	
	int qtd;
	
	if(cx < -CONST){
		qtd = ((int)(-cx))/10+1;
		printf("Giro a esquerda \n");
		for(int i=0; i<qtd; ++i) serialport_write(fd, "3");
		
		usleep(qtd*100000);
		
		return false;
	}
	
	if(cx > CONST){
		qtd = ((int)(cx))/10+1;
		printf("Giro a direita \n"); 
		for(int i=0; i<qtd; ++i) serialport_write(fd, "4");
		
		usleep(qtd*100000);
		
		return false;
	}

	return true;

}

#define MAR 10

bool ficar30cmFrontal(double alfa, double cx, double cz){
	printf("PERCORRENDO CATETOS DO TRIANGULO alfa = %lf", alfa);
	if(alfa<-MAR || alfa>MAR){
		double hip = sqrt(cx*cx+cz*cz); //calcula a hipotenusa através de cx e cz já que cy trata da altura e a aplicação é no plano
		double rad = fabs((M_PI/180)*alfa); //passa o angulo para radianos
		double co = sin(rad)*hip; //calcula o cateto oposto
		double ca = cos(rad)*hip; //calcula o cateto adjacente
		
		rotate(M_PI/2 - rad, alfa<0);
		
		goline(co);
		
		rotate(M_PI/2, alfa>0);
		
		//goline(ca-30);
		
		return false;
	}
	else return true;
}

bool ajustefino30cm(double cz){
	if(cz-30 > MAR){
		puts("FINO FRENTE");
		serialport_write(fd, "2"); //se tiver mto atras, vai um pouco pra frente
		serialport_write(fd, "2"); //se tiver mto atras, vai um pouco pra frente
		return false;
	}
	if(cz-30 < -MAR){
		puts("FINO TRAS");
		serialport_write(fd, "1"); //se tiver mto a frente, vai um pouco pra tras
		serialport_write(fd, "1"); //se tiver mto atras, vai um pouco pra frente
		return false;
	}
	puts("FINO OK");
	return true;
}

void goab(int lar, int com, bool cw){
	puts("GOAB?");
	rotate(M_PI/2, !cw);
	goline(lar/2.0+30);
	rotate(M_PI/2, cw);
	goline(com/2.0+30);
	rotate(M_PI/2, cw);
}

bool reduzirz(double cz){
	printf("Reduzir %lf\n", cz-30);
	int qtd = (cz-30)/2.5;
	if(cz>30){
		printf("reduzirz %d\n", qtd+1);
		for(int i=0; i<=qtd; ++i){
		
			serialport_write(fd, "2"); //se tiver mto atras, vai um pouco pra frente
			
		}
		
		usleep((qtd/2)*100000);
		
		return false;
	}
	return true;
}

bool verifydata(unsigned char *info){
	int pos = 0;
	if(info[pos++]!='[') return false;
	if(!isdigit(info[pos])) return false;
	while(isdigit(info[pos])) pos++;
	
	if(info[pos++]!=',') return false;
	if(!isdigit(info[pos])) return false;
	while(isdigit(info[pos])) pos++;
	
	if(info[pos++]!=']') return false;
	if(info[pos++]!='[') return false;
	if(!isdigit(info[pos])) return false;
	while(isdigit(info[pos])) pos++;
	
	if(info[pos++]!=',') return false;
	if(!isdigit(info[pos])) return false;
	while(isdigit(info[pos])) pos++;
	
	if(info[pos++]!=']') return false;
	if(info[pos]!='N' && info[pos]!='S' && info[pos]!='W' && info[pos]!='E') return false;
	pos++;
	
	if(info[pos]) return false; // verifica se nao existe nada além do desejado
	
	return true;
	
}

void arduino(quadrado3d posicao, double alfa, double beta, unsigned char *info, bool data)
{
	
	// padrão do info
	// [x objeto, y objeto][comprimento, largura] PC
	// PC =  Ponto Cardinal (N, S, L, O) Indicando para onde está orientado o robô ao ver o marcador
	double cx=(posicao.x[0]+posicao.x[1]+posicao.x[2]+posicao.x[3])/4.0;
	double cy=(posicao.y[0]+posicao.y[1]+posicao.y[2]+posicao.y[3])/4.0;
	double cz=(posicao.z[0]+posicao.z[1]+posicao.z[2]+posicao.z[3])/4.0;
	//2 frente //1 tras //3 esquerda //4 direita
    
	//CENTRALIZANDO O MARCADOR
	//puts("CENT");
	if(!centralizarMarcador(cx)) return;
	
	if(!reduzirz(cz)) return;
	
	if(!ficar30cmFrontal(alfa, cx, cz)) return;
	
	if(!ajustefino30cm(cz)) return;
	
	if(!data){
		puts("Sem leitura de dados");
		return;
	}
	
	if(strcmp((char*)info, "QUEIJO")==0){
		printf("QUEIJO ENCONTRADO NA COORDENADA (%d, %d)\nEND SUCCESS\n", QX, QY);
		printf("Alfa: %lf Beta: %lf\n", alfa, beta);
		exit(0);
	}
	
	if(!verifydata(info)){
		puts("Dados Incorretos no Marcador");
		return;
	}
	
	puts("DADOS OK");
	
	int xm, ym, lm, cm;
	char pc;
	
	sscanf((char*)info, "[%d,%d][%d,%d]%c", &xm, &ym, &cm, &lm, &pc); // FOI TROCADO O COMPRIMENTO PELA LARGURA
	
	double rx, ry;
	
	if(pc=='N') ym+=30+cm/2;
	if(pc=='S') ym-=30+cm/2;
	if(pc=='L') xm+=30+cm/2;
	if(pc=='O') xm-=30+cm/2;
	
	double qx = QX, qy = QY;
	
	puts((char*)info);
	printf("%d %d | %d %d | %c\n", xm, ym, lm, cm, pc);
	
	//return;
	
	if(xm<=qx && ym<=qy){
		
		//puts("AAA"); return;
		
		switch(pc){
			case 'N': goab(lm, cm, false);
					  break;
			case 'S': rotate(RAD180-atan((qx-xm)/(qy-ym)), false);
					  break;
			case 'E': goab(lm, cm, true);
					  break;
			case 'W': rotate(RAD90+atan((qx-xm)/(qy-ym)), true);
					  break;
		}
	}
	
	if(xm>=qx && ym>=qy){
		
		//puts("BBB"); return;
		
		switch(pc){
			case 'N': rotate(RAD180-atan((qx-xm)/(qy-ym)), false);
					  break;
			case 'S': goab(lm, cm, false);
					  break;
			case 'E': rotate(RAD90+atan((qx-xm)/(qy-ym)), true);
					  break;
			case 'W': goab(lm, cm, true);
					  break;
		}
	}
	
	if(xm<=qx && ym>=qy){
		
		//puts("CCC"); return;
		
		switch(pc){
			case 'N': rotate(RAD180-atan((qx-xm)/(qy-ym)), true);
					  break;
			case 'S': goab(lm, cm, true);
					  break;
			case 'E': goab(lm, cm, false);
					  break;
			case 'W': rotate(RAD90+atan((qx-xm)/(qy-ym)), false);
					  break;
		}
	}
	
	if(xm>=qx && ym<=qy){
		
		//puts("DDD"); return;
		
		switch(pc){
			case 'N': goab(lm, cm, true);
					  break;
			case 'S': rotate(RAD180-atan((qx-xm)/(qy-ym)), true);
					  break;
			case 'E': rotate(RAD90+atan((qx-xm)/(qy-ym)), false);
					  break;
			case 'W': goab(lm, cm, false);
					  break;
		}
	}
	

}

void procurar(){
	// for(int i=0; i<4; ++i) serialport_write(fd, "4"); // DIREITA
	// for(int i=0; i<4; ++i) serialport_write(fd, "3"); // ESQUERDA
}

int main(int argc,char *argv[])
{
	
	iniciaarduino();
	
	//PARAMETERS FOR DEBUGGING
	
    IplImage *camera, *po;

    // inicia o qrdecoder
    
    cvNamedWindow("janela",1);

    
    char key;
    
    CvFont normal, menor;
	cvInitFont( &normal, CV_FONT_HERSHEY_SIMPLEX, 0.5, 1.5, 0, 2);
	cvInitFont( &menor, CV_FONT_HERSHEY_PLAIN, 0.5, 2, 0, 2);
    
    char tela[100];
    
    while(true){
		system("wget -q -p http://10.20.128.238/snapshot.cgi?user=udesc\\&pwd=udesc");
		
		camera = cvLoadImage("10.20.128.238/snapshot.cgi?user=udesc&pwd=udesc",1);

		if(!camera) continue;
		
		key = cvWaitKey(100);
		
		if(key == 'q') break;
		
		quadrado3d position;
		quadrado2d projected;
		double rotx, roty;
		unsigned char *data;
		bool getpo, getdata;
		
		qrpox(camera, position, projected, rotx, roty, data, getpo, getdata);
		
		IplImage *janela = cvCloneImage(camera);
		
		if(getdata){
			sprintf(tela, "Content: %s", data);
			cvPutText( janela, tela, cvPoint(0, 475), &menor, CV_RGB(0,0,139) );
		}
		
		if(getpo){
			
			cvLine(janela,cvPoint(projected.x[0], projected.y[0]),cvPoint(projected.x[1], projected.y[1]),CV_RGB(0,191,255),1);
			cvLine(janela,cvPoint(projected.x[1], projected.y[1]),cvPoint(projected.x[2], projected.y[2]),CV_RGB(0,191,255),1);
			cvLine(janela,cvPoint(projected.x[2], projected.y[2]),cvPoint(projected.x[3], projected.y[3]),CV_RGB(0,191,255),1);
			cvLine(janela,cvPoint(projected.x[3], projected.y[3]),cvPoint(projected.x[0], projected.y[0]),CV_RGB(0,191,255),1);
			
			for(int i=0; i<4; i++){
				sprintf(tela, "%c=(%.1lf; %.1lf; %.5lf)",'A'+i, position.x[i], position.y[i], position.z[i]-0.36);
				cvPutText( janela, tela, cvPoint(0, 20*(i+1)), &menor, CV_RGB(255,165,0) );
				sprintf(tela, "%c", 'A'+i);
				cvPutText( janela, tela, cvPoint(projected.x[i]-5, projected.y[i]+5), &normal, CV_RGB(200,0,0) );
			}
			
			sprintf(tela, "ALFA: %.2lf", rotx);
			cvPutText( janela, tela, cvPoint(500, 20), &menor, CV_RGB(255,165,0) );
			sprintf(tela, "BETA: %.2lf", roty);
			cvPutText( janela, tela, cvPoint(500, 40), &menor, CV_RGB(255,165,0) );
		}
		
		cvShowImage("janela",janela);
		
		if(getpo) arduino(position, rotx, roty, data, getdata);
		else procurar();
        
    }
    finalizaarduino();
    return(0);
}
