#include <algorithm>
#include <queue>

#define RESX 640.0
#define RESY 480.0
#define QRCODEALTURA 10.0
#define QRCODELARGURA 10.0

#define celula(img, i, j) (img->imageData[(i)*img->widthStep+(j)*img->nChannels])
//resolução da câmera em X e Y

void qrpox(IplImage *camera, quadrado3d &reconstruido, quadrado2d &projected, double &alfa, double &beta, unsigned char *data, bool &getpo, bool &getdata){
	
	
	QrDecoderHandle decoder=qr_decoder_open();
	IplImage *po;
	IplImage *janela=NULL,*bin=NULL;
	quadrado2d projetado;
	unsigned char *text = NULL;
    unsigned char *atext = NULL;
    atext=new unsigned char[1];
    atext[0]=0;
    int text_size=0;
	
	getdata = false;
		
	janela=cvCloneImage(camera);
	
	po = cvCreateImage( cvGetSize(camera), IPL_DEPTH_8U, 1 );
	
	cvCvtColor( camera, po, CV_RGB2GRAY );
	
	cvAdaptiveThreshold(po, po, 255, CV_ADAPTIVE_THRESH_MEAN_C, CV_THRESH_BINARY, 41, 40);
	
	//cvErode(po, po, NULL, 1); //eliminar ruídos?
	
	IplImage *cl = cvCloneImage(po);
	
	// FLOOD FILL TO CLOSE HOLE
	
	for(int i=0;i<po->height;i++){
		if(celula(po, i, 0)){
			cvFloodFill(po, cvPoint(0, i), cvScalar(0));
		}
		if(celula(po, i, po->width-1)){
			cvFloodFill(po, cvPoint(po->width-1, i), cvScalar(0));
		}
	}
	for(int j=0;j<po->width;j++){
		if(celula(po, 0, j)){
			cvFloodFill(po, cvPoint(j, 0), cvScalar(0));
		}
		if(celula(po, po->height-1, j)){
			cvFloodFill(po, cvPoint(j, po->height-1), cvScalar(0));
		}
	}
	
	// MY CLOSE HOLE
	
	cl = cvCloneImage(po);
	
	cvFloodFill(cl, cvPoint(0, 0), cvScalar(255));
	
	for(int i=0;i<po->height;i++){
		for(int j=0;j<po->width;j++){
			if(cl->imageData[i*po->widthStep+j*po->nChannels]==0)
			   po->imageData[i*po->widthStep+j*po->nChannels]=255;
		}
	}

	IplImage *aux;
	aux = cvCloneImage(po);
	cvErode(aux, aux, NULL, 10); //deixa só o marcador

	IplImage *tab = cvCreateImage( cvGetSize(camera), IPL_DEPTH_8U, 1 );
	for(int i=0; i<RESY; i++) for(int j=0; j<RESX; j++) celula(tab, i, j)=0;

	pair<pair<int, int>, int> seed;
	seed = make_pair(make_pair(-1,-1), 0);
	
	queue<pair<int, int> > fila;
	
	for(int i=0;i<aux->height;i++){
		for(int j=0;j<aux->width;j++){
			if(celula(aux, i, j) && !celula(tab, i, j)){
				fila.push(make_pair(i, j));
				int area = 0;
				while(!fila.empty()){
					int i = fila.front().first;
					int j = fila.front().second;
					fila.pop();
					area++;
					if(i-1>=0) if(celula(aux, i-1, j) && !celula(tab, i-1, j)){
						celula(tab, i-1, j) = -1;
						fila.push(make_pair(i-1, j));
					}
					if(j-1>=0) if(celula(aux, i, j-1) && !celula(tab, i, j-1)){
						celula(tab, i, j-1) = -1;
						fila.push(make_pair(i, j-1));
					}
					if(i+1<=RESY && celula(aux, i+1, j) && !celula(tab, i+1, j)){
						celula(tab, i+1, j) = -1;
						fila.push(make_pair(i+1, j));
					}
					if(j+1<=RESX && celula(aux, i, j+1) && !celula(tab, i, j+1)){
						celula(tab, i, j+1) = -1;
						fila.push(make_pair(i, j+1));
					}
				}
				if(seed.second < area){
					seed = make_pair(make_pair(i, j), area);
				}
			}
		}
	}
	
	//RECONSTRUCAO DO MAIOR MARCADOR ENCONTRADO NA CENA
	if(seed.second!=0){
		getpo = true;
		fila.push(seed.first);
		for(int i=0; i<RESY; i++) for(int j=0; j<RESX; j++) celula(aux, i, j)=0;
	}else getpo = false;
	
	while(!fila.empty()){
		int i = fila.front().first;
		int j = fila.front().second;
		fila.pop();
		if(i-1>=0) if(celula(po, i-1, j) && !celula(aux, i-1, j)){
			celula(aux, i-1, j) = -1;
			fila.push(make_pair(i-1, j));
		}
		if(j-1>=0) if(celula(po, i, j-1) && !celula(aux, i, j-1)){
			celula(aux, i, j-1) = -1;
			fila.push(make_pair(i, j-1));
		}
		if(i+1<=RESY && celula(po, i+1, j) && !celula(aux, i+1, j)){
			celula(aux, i+1, j) = -1;
			fila.push(make_pair(i+1, j));
		}
		if(j+1<=RESX && celula(po, i, j+1) && !celula(aux, i, j+1)){
			celula(aux, i, j+1) = -1;
			fila.push(make_pair(i, j+1));
		}
	}
	
	cvCanny( aux, aux, 50, 200, 3 );

	CvPoint canto[4];
	canto[1] = cvPoint(RESY,0);
	canto[2] = cvPoint(0,0);
	canto[0] = cvPoint(RESY,RESX);
	canto[3] = cvPoint(0, RESX);

	for(int i=0;i<aux->height;i++){
		for(int j=0;j<aux->width;j++){
			if(!celula(aux, i, j)) continue;
			if(canto[2].x+canto[2].y < i+j){
				canto[2] = cvPoint(i,j);
			}
			if(canto[0].x+canto[0].y > i+j){
				canto[0] = cvPoint(i,j);
			}
			if(canto[1].x+(RESY-canto[1].y) > i+(RESY-j)){
				canto[1] = cvPoint(i,j);
			}
			if((RESX-canto[3].x)+canto[3].y > (RESX-i)+j){
				canto[3] = cvPoint(i,j);
			}
		}
	}
	for(int i=0; i<4; i++) canto[i] = cvPoint(canto[i].y, canto[i].x);
	
	qr_decoder_set_image_buffer(decoder,janela);
	
	cvCopy(camera,janela);
	if(!qr_decoder_is_busy(decoder)){
		if(camera->origin) cvConvertImage(camera,janela,CV_CVTIMG_FLIP);
		else cvCopy(camera,janela);

		// tenta decodificar para todas as qualidades
		
		short sz,stat;
		for(sz=25,stat=0;
			(sz>=3)&&((stat&QR_IMAGEREADER_DECODED)==0);
			sz-=2)
			stat=qr_decoder_decode(decoder,sz);
		
		//imprimir texto decodificado
		
		QrCodeHeader header;
		if(qr_decoder_get_header(decoder,&header)){
			getdata = true;
			if(text_size<header.byte_size+1){
				if(text) delete text;
				text_size=header.byte_size+1;
				text=new unsigned char[text_size];
			}
			qr_decoder_get_body(decoder,text,text_size);
			
			if(janela->origin) cvConvertImage(janela,janela,CV_CVTIMG_FLIP);
		}
	}
	
	if(getpo){
		
		for(int i=0;i<4;i++){
			projected.x[i] = canto[i].x-319.5;
			projected.y[i] = canto[i].y-239.5;
		}
		for(int i=0;i<4;i++){
			projetado.x[i] = projected.x[(i+1)%4]-319.5;
			projetado.y[i] = projected.y[(i+1)%4]-239.5;
		}
		
		
		projetado.area = QRCODEALTURA*QRCODELARGURA;
		quadrado2dto3d(&reconstruido, &projetado);
		
		direcao(&reconstruido, &alfa, &beta);
		
	}
	
	// ENVIA AS INFORMAÇÕES PARA O ARDUIDO, O ARDUINO TOMA AS DEMAIS DECISÕES, ESTA ETAPA É SEPARADA E INERENTE AS DEMAIS
	// getdata INDICA SE EXISTE PO+DADOS(true) OU APENAS PO(false)
	
	cvReleaseImage(&camera);
	qr_decoder_close(decoder);
	
}
