/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.ui;

import com.udesc.larva.delta.ui.Interface;
import com.udesc.larva.delta.ui.element.Curvas;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class MyCanvas
extends Canvas {
    Interface inte;
    Curvas curvas;
    int x = 0;
    int y = 0;
    int z = 0;

    public MyCanvas(Interface inte) {
        this.inte = inte;
        BCML bcmlistener = new BCML();
        this.addMouseListener(bcmlistener);
        this.addMouseMotionListener(bcmlistener);
        this.setBackground(Color.white);
        this.curvas = new Curvas();
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.clearRect(0, 0, size.width, size.height);
        this.drawBorder(g);
        this.curvas.paint(g, this.inte);
        if (this.x == 1) {
            this.curvas.fecha(g);
            this.x = 0;
        }
        if (this.y == 1) {
            this.curvas.salvaPlano();
            this.curvas.limpaPlano(g);
            this.y = 0;
            this.repaint();
        }
        if (this.z == 1) {
            this.curvas.limpaPlano(g);
            this.z = 0;
            this.repaint();
        }
    }

    public void drawBorder(Graphics g) {
        Dimension size = this.getSize();
        g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(620, 360);
    }

    public void togglePoints() {
        this.curvas.togglePoints();
        this.repaint();
    }

    public void novo() {
        this.curvas.novo();
        this.repaint();
    }

    public void delete() {
        this.curvas.delPt();
        this.repaint();
    }

    public void fecha() {
        this.x = 1;
        this.repaint();
    }

    public void salvaPlano() {
        this.y = 1;
        this.repaint();
    }

    public void limpaPlano() {
        this.z = 1;
        this.repaint();
    }

    public void salvar() {
        this.curvas.salvar();
        this.repaint();
    }

    class BCML
    extends MouseAdapter
    implements MouseMotionListener {
        BCML() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MyCanvas.this.curvas.setCurrPoint(e.getPoint());
            MyCanvas.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MyCanvas.this.curvas.moveCurrPtTo(e.getPoint());
            MyCanvas.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

