/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.ui;

import com.udesc.larva.delta.ui.InterfaceAction;
import com.udesc.larva.delta.ui.InterfaceTiling;
import com.udesc.larva.delta.ui.vo.CorrespondenceAreaTypeEnum;
import com.udesc.larva.delta.ui.vo.CorrespondenceDistanceTypeEnum;
import com.udesc.larva.delta.ui.vo.CorrespondenceInterfaceParameter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class InterfaceCorrespondence
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JButton buttonCancel;
    private JButton buttonOK;
    private ButtonGroup correspondenceAreaGroup;
    private ButtonGroup correspondenceFXGroup;
    private JLabel deltaLabel;
    private JTextField deltaValue;
    private JPanel jPanel1;
    private JPanel optionPanelCorrespondence;
    private JLabel rLabel;
    private JTextField rValue;
    private JRadioButton rbBoundingCircle;
    private JRadioButton rbBoundingBox;
    private JRadioButton rbDeltaCon;
    private JRadioButton rbPerimeter;
    private JRadioButton rbR2;
    private JRadioButton rbR3;
    private InterfaceAction action;

    public InterfaceCorrespondence(InterfaceAction action) {
        this.initComponents();
        this.action = action;
        this.rValue.setEnabled(false);
    }

    private void initComponents() {
        this.correspondenceAreaGroup = new ButtonGroup();
        this.correspondenceFXGroup = new ButtonGroup();
        this.optionPanelCorrespondence = new JPanel();
        this.rbDeltaCon = new JRadioButton();
        this.rbBoundingBox = new JRadioButton();
        this.rbBoundingCircle = new JRadioButton();
        this.rbPerimeter = new JRadioButton();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.rbR2 = new JRadioButton();
        this.rbR3 = new JRadioButton();
        this.deltaValue = new JTextField();
        this.deltaLabel = new JLabel();
        this.rLabel = new JLabel();
        this.rValue = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Correspondence Option");
        this.optionPanelCorrespondence.setBorder(BorderFactory.createTitledBorder("Choose an option"));
        this.correspondenceAreaGroup.add(this.rbDeltaCon);
        this.rbDeltaCon.setSelected(true);
        this.rbDeltaCon.setText("Default (Delta Connection)");
        this.rbDeltaCon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceCorrespondence.this.rbDeltaConActionPerformed(evt);
            }
        });
        this.correspondenceAreaGroup.add(this.rbBoundingBox);
        this.rbBoundingBox.setText("Bounding Box Area");
        this.rbBoundingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceCorrespondence.this.rbBoundingBoxActionPerformed(evt);
            }
        });
        this.correspondenceAreaGroup.add(this.rbBoundingCircle);
        this.rbBoundingCircle.setText("Bounding Circle Area");
        this.rbBoundingCircle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceCorrespondence.this.rbBoundingAreaActionPerformed(evt);
            }
        });
        this.correspondenceAreaGroup.add(this.rbPerimeter);
        this.rbPerimeter.setText("Perimeter");
        this.rbPerimeter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceCorrespondence.this.rbPerimeterActionPerformed(evt);
            }
        });
        GroupLayout optionPanelCorrespondenceLayout = new GroupLayout(this.optionPanelCorrespondence);
        this.optionPanelCorrespondence.setLayout(optionPanelCorrespondenceLayout);
        optionPanelCorrespondenceLayout.setHorizontalGroup(optionPanelCorrespondenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionPanelCorrespondenceLayout.createSequentialGroup().addGroup(optionPanelCorrespondenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbDeltaCon).addComponent(this.rbBoundingBox).addComponent(this.rbBoundingCircle).addComponent(this.rbPerimeter)).addContainerGap(-1, Short.MAX_VALUE)));
        optionPanelCorrespondenceLayout.setVerticalGroup(optionPanelCorrespondenceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionPanelCorrespondenceLayout.createSequentialGroup().addContainerGap().addComponent(this.rbDeltaCon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbPerimeter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.rbBoundingBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbBoundingCircle).addContainerGap()));
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceCorrespondence.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancelar");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InterfaceCorrespondence.this.buttonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Choose a distance option"));
        this.correspondenceFXGroup.add(this.rbR2);
        this.rbR2.setText("2D");
        this.rbR2.setSelected(true);
        this.correspondenceFXGroup.add(this.rbR3);
        this.rbR3.setText("3D");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbR2).addComponent(this.rbR3)).addContainerGap(128, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rbR2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbR3)));
        this.deltaLabel.setText("Delta (%) (*):");
        this.rLabel.setText("R (%):");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.optionPanelCorrespondence, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonOK, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -1, 108, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rLabel).addComponent(this.deltaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deltaValue, -1, 97, Short.MAX_VALUE).addComponent(this.rValue, -1, 97, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionPanelCorrespondence, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deltaLabel).addComponent(this.deltaValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rLabel).addComponent(this.rValue, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOK).addComponent(this.buttonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void rbBoundingAreaActionPerformed(ActionEvent evt) {
        this.rbR2.setEnabled(true);
        this.rbR3.setEnabled(true);
        this.rValue.setEnabled(true);
        this.rbR2.setSelected(true);
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        CorrespondenceInterfaceParameter parameterInterfaceCorrespondence = new CorrespondenceInterfaceParameter();
        if (this.rbBoundingCircle.isSelected()) {
            parameterInterfaceCorrespondence.setCorrespondenceAreaType(CorrespondenceAreaTypeEnum.BOUNDING_CIRCLE_AREA);
        } else if (this.rbBoundingBox.isSelected()) {
            parameterInterfaceCorrespondence.setCorrespondenceAreaType(CorrespondenceAreaTypeEnum.BOUNDING_BOX_AREA);
        } else if (this.rbDeltaCon.isSelected()) {
            parameterInterfaceCorrespondence.setCorrespondenceAreaType(CorrespondenceAreaTypeEnum.DEFAULT_DELTA);
        } else if (this.rbPerimeter.isSelected()) {
            parameterInterfaceCorrespondence.setCorrespondenceAreaType(CorrespondenceAreaTypeEnum.PERIMETER);
        }
        if (this.rbR2.isSelected()) {
            parameterInterfaceCorrespondence.setDistanceType(CorrespondenceDistanceTypeEnum.R2);
        } else {
            parameterInterfaceCorrespondence.setDistanceType(CorrespondenceDistanceTypeEnum.R3);
        }
        double delta = Double.parseDouble(this.deltaValue.getText());
        parameterInterfaceCorrespondence.setDelta(delta);
        if (this.rValue.getText() != null && !this.rValue.getText().equals("")) {
            parameterInterfaceCorrespondence.setRange(Double.parseDouble(this.rValue.getText()));
        } else {
            parameterInterfaceCorrespondence.setRange(0.0);
        }
        this.action.setParametroCorrespondence(parameterInterfaceCorrespondence);
        InterfaceTiling interfaceTiling = new InterfaceTiling(this.action);
        interfaceTiling.setVisible(true);
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void rbDeltaConActionPerformed(ActionEvent evt) {
        this.rValue.setEnabled(false);
        this.rbR2.setSelected(true);
    }

    private void rbPerimeterActionPerformed(ActionEvent evt) {
        this.rbR2.setEnabled(true);
        this.rbR3.setEnabled(true);
        this.rValue.setEnabled(true);
        this.rbR2.setSelected(true);
    }

    private void rbBoundingBoxActionPerformed(ActionEvent evt) {
        this.rbR2.setEnabled(true);
        this.rbR3.setEnabled(true);
        this.rValue.setEnabled(true);
        this.rbR2.setSelected(true);
    }
}

