/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.ui;

import com.udesc.larva.delta.files.XMLtoVRML;
import com.udesc.larva.delta.interpolation.DeltaConnection;
import com.udesc.larva.delta.interpolation.ParametrosIniciais;
import com.udesc.larva.delta.ui.Interface;
import com.udesc.larva.delta.ui.MyCanvas;
import com.udesc.larva.delta.ui.vo.CorrespondenceInterfaceParameter;
import com.udesc.larva.delta.ui.vo.TileInterfaceParameter;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class InterfaceAction {
    private MyCanvas canvas;
    private XMLtoVRML converter;
    private ParametrosIniciais parametro;
    private JButton nextButton;
    private JButton viewButton;
    private JButton interpolationButton;
    private JLabel coordinateY;
    private JLabel coordinateX;
    private JLabel genericLabel;
    private TileInterfaceParameter parametroTiling;
    private CorrespondenceInterfaceParameter parametroCorrespondence;

    public InterfaceAction(Interface deltaInterface) {
        this.canvas = deltaInterface.getCanvas();
        this.converter = deltaInterface.getObj();
        this.nextButton = deltaInterface.getNextButton();
        this.viewButton = deltaInterface.getViewButton();
        this.interpolationButton = deltaInterface.getInterpolationButton();
        this.coordinateY = deltaInterface.getCoordinateY();
        this.coordinateX = deltaInterface.getCoordinateY();
        this.genericLabel = deltaInterface.getGenericLabel();
        this.parametroTiling = new TileInterfaceParameter();
        this.parametroCorrespondence = new CorrespondenceInterfaceParameter();
    }

    public void deletarButtonClicked(ActionEvent e) {
        this.canvas.delete();
    }

    public void novoButtonClicked(ActionEvent e) {
        this.canvas.novo();
        this.nextButton.setEnabled(false);
        this.coordinateX.setText(" X :");
        this.coordinateY.setText(" Y :");
        this.genericLabel.setText("  ");
    }

    public void salvaButtonClicked(ActionEvent e) {
        this.canvas.salvar();
        this.nextButton.setEnabled(false);
        this.coordinateX.setText(" X :");
        this.coordinateY.setText(" Y :");
        this.genericLabel.setText("  Planos salvos !");
    }

    public void limpaButtonClicked(ActionEvent e) {
        this.canvas.limpaPlano();
        this.nextButton.setEnabled(false);
        this.coordinateX.setText(" X :");
        this.coordinateY.setText(" Y :");
        this.genericLabel.setText("  Plano limpo");
    }

    public void proximoButtonClicked(ActionEvent e) {
        this.canvas.salvaPlano();
        this.nextButton.setEnabled(false);
        this.coordinateX.setText(" X :");
        this.coordinateY.setText(" Y :");
        this.genericLabel.setText("  Novo plano");
    }

    public void fechaButtonClicked(ActionEvent e) {
        this.canvas.fecha();
        this.nextButton.setEnabled(true);
        this.genericLabel.setText("  Curva fechada ! Desenhe a pr\u00f3xima curva ou passe para o pr\u00f3ximo plano");
    }

    public void carregaXMLButtonClicked(ActionEvent e) {
        this.parametro = this.converter.carregarXML();
        if (this.parametro != null) {
            this.viewButton.setEnabled(true);
            this.interpolationButton.setEnabled(true);
            this.genericLabel.setText("  XML carregado com sucesso !");
        } else {
            this.genericLabel.setText("  N\u00e3o foi poss\u00edvel carregar o documento XML");
        }
    }

    public void visualizaButtonClicked(ActionEvent e) {
        this.converter.abrirVRML();
        this.converter.gerarPlanos(this.parametro);
        this.converter.fecharVRML();
    }

    public void interpolaButtonClicked(ActionEvent e) {
        this.converter.abrirVRML();
        try {
            DeltaConnection delta = new DeltaConnection(this.converter);
            delta.interpolaDeltaConnection(this.parametro, this.parametroTiling, this.parametroCorrespondence);
        }
        catch (NumberFormatException n) {
            n.printStackTrace();
            JOptionPane.showMessageDialog(null, "Este campo somente suporta caracteres num\u00e9ricos !!! Tente novamente.", "Erro", TrayIcon.MessageType.ERROR.ordinal());
        }
        this.converter.fecharVRML();
    }

    public void sobreButtonClicked(ActionEvent e) {
        JOptionPane.showMessageDialog(null, "\n   Este aplicativo \u00e9 resultado do Trabalho de Conlus\u00e3o de Curso\nsob o t\u00edtulo de \"Delta+ Connection: Reconstru\u00e7\u00e3o 3D de Objetos com Sess\u00f5es Planares Vari\u00e1veis\"\n\n\nAutor: Leonardo Kandler Bittencourt\nOrientador: Marcelo da Silva Hounsell\n\nLaborat\u00f3rio de Realidade Virtual Aplicada - LARVA\nUniversidade do Estado de Santa Catarina - UDESC\n\n", "Sobre", -1);
    }

    public void setParametroTiling(TileInterfaceParameter parametroTiling) {
        this.parametroTiling = parametroTiling;
    }

    public void setParametroCorrespondence(CorrespondenceInterfaceParameter parametroCorrespondence) {
        this.parametroCorrespondence = parametroCorrespondence;
    }
}

