/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.metricas;

import com.udesc.larva.delta.interpolation.CalculoAuxiliar;
import com.udesc.larva.delta.ui.vo.LinkingOptionEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class CalculoMetrica {
    private int numeroSegmentoSpan = 0;
    private double tamanhoTotalSegmentosSpans = 0.0;
    private HashMap<Double, Integer> tamanhoSegmentosSpan = new HashMap();
    private int numeroSpan = 0;
    private double tamanhoTotalSpans = 0.0;
    private HashMap<Double, Integer> tamanhoSpan = new HashMap();

    private void adicionarSpan(Double numero) {
        if (this.tamanhoSpan.get(numero) != null) {
            this.tamanhoSpan.put(numero, new Integer(this.tamanhoSpan.get(numero) + 1));
        } else {
            this.tamanhoSpan.put(numero, new Integer(1));
        }
        this.tamanhoTotalSpans += numero.doubleValue();
        ++this.numeroSpan;
    }

    private void adicionarSegmentoSpan(Double numero) {
        if (this.tamanhoSegmentosSpan.get(numero) != null) {
            this.tamanhoSegmentosSpan.put(numero, new Integer(this.tamanhoSegmentosSpan.get(numero) + 1));
        } else {
            this.tamanhoSegmentosSpan.put(numero, new Integer(1));
        }
        this.tamanhoTotalSegmentosSpans += numero.doubleValue();
        ++this.numeroSegmentoSpan;
    }

    public void metricaSomaSpanSegmento(String topologia, String geometria, LinkingOptionEnum linkingType) {
        String[] pontosTopologia;
        CalculoAuxiliar calculo = new CalculoAuxiliar();
        String[] pontosGeometria = geometria.split(" , \r\n");
        String[] stringArray = pontosTopologia = topologia.split(" -1  ");
        int n = pontosTopologia.length;
        int n2 = 0;
        while (n2 < n) {
            String ponto = stringArray[n2];
            String[] top = ponto.split(" ");
            double tamanho = 0.0;
            if (!top[0].equals("\n\r")) {
                String ponto1 = pontosGeometria[Integer.parseInt(top[0])];
                String ponto2 = pontosGeometria[Integer.parseInt(top[1])];
                String[] ponto1Aux = ponto1.split(" ");
                String[] ponto2Aux = ponto2.split(" ");
                tamanho = calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto1Aux), this.converteStringFloat(ponto2Aux));
                String ponto3 = pontosGeometria[Integer.parseInt(top[2])];
                String[] ponto3Aux = ponto3.split(" ");
                if (linkingType.equals((Object)LinkingOptionEnum.QUADRANGULAR)) {
                    String ponto4 = pontosGeometria[Integer.parseInt(top[3])];
                    String[] ponto4Aux = ponto4.split(" ");
                    this.adicionarSegmentoSpan(tamanho += calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto2Aux), this.converteStringFloat(ponto3Aux)));
                    this.adicionarSegmentoSpan(tamanho += calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto3Aux), this.converteStringFloat(ponto4Aux)));
                    this.adicionarSegmentoSpan(tamanho += calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto4Aux), this.converteStringFloat(ponto1Aux)));
                } else {
                    this.adicionarSegmentoSpan(tamanho += calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto2Aux), this.converteStringFloat(ponto3Aux)));
                    this.adicionarSegmentoSpan(tamanho += calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto3Aux), this.converteStringFloat(ponto1Aux)));
                }
                this.adicionarSegmentoSpan(tamanho);
            }
            ++n2;
        }
    }

    public void metricaSpan(String topologia, String geometria, LinkingOptionEnum linkingType) {
        String[] pontosTopologia;
        CalculoAuxiliar calculo = new CalculoAuxiliar();
        String[] pontosGeometria = geometria.split(" , \r\n");
        String[] stringArray = pontosTopologia = topologia.split(" -1  ");
        int n = pontosTopologia.length;
        int n2 = 0;
        while (n2 < n) {
            String ponto = stringArray[n2];
            String[] top = ponto.split(" ");
            double tamanho = 0.0;
            if (!top[0].equals("\n\r")) {
                String ponto1 = pontosGeometria[Integer.parseInt(top[0])];
                String ponto2 = pontosGeometria[Integer.parseInt(top[1])];
                String[] ponto1Aux = ponto1.split(" ");
                String[] ponto2Aux = ponto2.split(" ");
                tamanho = calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto1Aux), this.converteStringFloat(ponto2Aux));
                this.adicionarSpan(tamanho);
                String ponto3 = pontosGeometria[Integer.parseInt(top[2])];
                String[] ponto3Aux = ponto3.split(" ");
                if (linkingType.equals((Object)LinkingOptionEnum.QUADRANGULAR)) {
                    String ponto4 = pontosGeometria[Integer.parseInt(top[3])];
                    String[] ponto4Aux = ponto4.split(" ");
                    tamanho = calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto3Aux), this.converteStringFloat(ponto4Aux));
                } else {
                    tamanho = calculo.getDistancia3DEntrePontos(this.converteStringFloat(ponto2Aux), this.converteStringFloat(ponto3Aux));
                }
                this.adicionarSpan(tamanho);
            }
            ++n2;
        }
    }

    public void imprimeResultadoSegmentoSpan() {
        System.out.println("N\u00famero de Spans e Segmentos: " + this.numeroSegmentoSpan);
        System.out.println("Tamanho total Spans e Segmentos: " + this.tamanhoTotalSegmentosSpans);
        System.out.println("Menor Spans e Segmentos: " + this.minimo(this.tamanhoSegmentosSpan));
        System.out.println("Maior Spans e Segmentos: " + this.maximo(this.tamanhoSegmentosSpan));
        System.out.println("M\u00e9dia Spans e Segmentos: " + this.media(this.tamanhoTotalSegmentosSpans, this.numeroSegmentoSpan));
        System.out.println("Mediana Spans e Segmentos: " + this.mediana(this.tamanhoSegmentosSpan));
        System.out.println("Moda Spans e Segmentos: " + this.moda(this.tamanhoSegmentosSpan));
        System.out.println("Desvio padr\u00e3o Spans e Segmentos: " + this.desvioPadrao(this.tamanhoSegmentosSpan, this.tamanhoTotalSegmentosSpans, this.numeroSegmentoSpan));
    }

    public void imprimeResultadoSpan() {
        System.out.println("N\u00famero de span: " + this.numeroSpan);
        System.out.println("Tamanho total: " + this.tamanhoTotalSpans);
        System.out.println("Menor span: " + this.minimo(this.tamanhoSpan));
        System.out.println("Maior span: " + this.maximo(this.tamanhoSpan));
        System.out.println("M\u00e9dia: " + this.media(this.tamanhoTotalSpans, this.numeroSpan));
        System.out.println("Mediana: " + this.mediana(this.tamanhoSpan));
        System.out.println("Moda: " + this.moda(this.tamanhoSpan));
        System.out.println("Desvio padr\u00e3o: " + this.desvioPadrao(this.tamanhoSpan, this.tamanhoTotalSpans, this.numeroSpan));
    }

    public Double maximo(HashMap<Double, Integer> hashTamanho) {
        TreeSet<Double> colAux = new TreeSet<Double>();
        colAux.addAll(hashTamanho.keySet());
        return (Double)colAux.last();
    }

    public Double minimo(HashMap<Double, Integer> hashTamanho) {
        TreeSet<Double> colAux = new TreeSet<Double>();
        colAux.addAll(hashTamanho.keySet());
        return (Double)colAux.first();
    }

    public Double media(double tamanhoSpans, int numeroSpan) {
        return tamanhoSpans / (double)numeroSpan;
    }

    public Double mediana(HashMap<Double, Integer> hashTamanho) {
        TreeSet<Double> colOrdenada = new TreeSet<Double>();
        ArrayList<Double> colAux = new ArrayList<Double>();
        for (Double valor : hashTamanho.keySet()) {
            int quantidade = hashTamanho.get(valor);
            int i = 0;
            while (i < quantidade) {
                colOrdenada.add(valor);
                ++i;
            }
        }
        colAux.addAll(colOrdenada);
        if (colAux.size() % 2 != 0) {
            return (Double)colAux.get((colAux.size() + 1) / 2);
        }
        return (Double)colAux.get(colAux.size() / 2) + (Double)colAux.get(colAux.size() / 2 + 1);
    }

    public Collection<Double> moda(HashMap<Double, Integer> hashTamanho) {
        Integer maior = null;
        HashSet<Double> resultado = new HashSet<Double>();
        for (Double valor : hashTamanho.keySet()) {
            Integer current = hashTamanho.get(valor);
            if (maior == null) {
                maior = current;
            }
            if (maior.compareTo(current) > 0) continue;
            maior = current;
            resultado.add(valor);
        }
        Iterator<Double> iterator = resultado.iterator();
        while (iterator.hasNext()) {
            Double numero = iterator.next();
            if (hashTamanho.get(numero).compareTo(maior) >= 0) continue;
            iterator.remove();
        }
        return resultado;
    }

    public Double desvioPadrao(HashMap<Double, Integer> hashTamanho, double tamanhoSpans, int numeroSpans) {
        Double media = this.media(tamanhoSpans, numeroSpans);
        Double aux = 0.0;
        for (Double tamanho : hashTamanho.keySet()) {
            aux = aux + Math.pow(tamanho - media, 2.0);
        }
        return Math.sqrt(1.0 / aux);
    }

    public float[] converteStringFloat(String[] ponto) {
        float[] retorno = new float[3];
        int i = 0;
        while (i < ponto.length) {
            retorno[i] = Float.parseFloat(ponto[i]);
            ++i;
        }
        return retorno;
    }
}

