/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.interpolation;

import com.udesc.larva.delta.files.XMLtoVRML;
import com.udesc.larva.delta.interpolation.AreasVO;
import com.udesc.larva.delta.interpolation.CalculoAuxiliar;
import com.udesc.larva.delta.interpolation.DistanciasVO;
import com.udesc.larva.delta.interpolation.ParametrosIniciais;
import com.udesc.larva.delta.metricas.CalculoMetrica;
import com.udesc.larva.delta.ui.vo.CorrespondenceAreaTypeEnum;
import com.udesc.larva.delta.ui.vo.CorrespondenceInterfaceParameter;
import com.udesc.larva.delta.ui.vo.OffsetOptionEnum;
import com.udesc.larva.delta.ui.vo.TileInterfaceParameter;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class DeltaConnection {
    private CalculoMetrica metrica = new CalculoMetrica();
    private XMLtoVRML converter;
    private Logger log;
    private int numeroPontosGerados = 0;
    private long tempoFirstPoint = 0L;
    private long tempoReordering = 0L;
    private long tempoBalancing = 0L;
    private long tempoOffSetting = 0L;
    private long tempoLinking = 0L;

    public DeltaConnection(XMLtoVRML converter) {
        this.converter = converter;
        this.log = Logger.getLogger(DeltaConnection.class.getCanonicalName());
    }

    public void interpolaDeltaConnection(ParametrosIniciais parametro, TileInterfaceParameter parametroTiling, CorrespondenceInterfaceParameter parametroCorrespondence) throws NumberFormatException {
        CalculoAuxiliar calculo = new CalculoAuxiliar();
        long t1 = System.currentTimeMillis();
        long t2 = System.currentTimeMillis();
        double[][][] centroides = null;
        AreasVO areas = new AreasVO();
        t1 = System.currentTimeMillis();
        centroides = calculo.getCentroides(parametro.getPlanos(), OffsetOptionEnum.MEDIA_EXTREMOS_X_Y);
        DistanciasVO distanciasVO = null;
        switch (parametroCorrespondence.getCorrespondenceAreaType()) {
            case DEFAULT_DELTA: {
                distanciasVO = calculo.getDeltaPlusMinimoMaximo(centroides, parametro.getNumeroPlanos(), parametroCorrespondence);
                break;
            }
            case BOUNDING_CIRCLE_AREA: {
                areas = calculo.getBoundingCircleAreas(parametro.getPlanos());
                distanciasVO = calculo.getDeltaPlusMinimoMaximo(centroides, parametro.getNumeroPlanos(), parametroCorrespondence);
                break;
            }
            case BOUNDING_BOX_AREA: {
                areas = calculo.getAreaCurvasBoundingBox(parametro.getPlanos());
                distanciasVO = calculo.getDeltaPlusMinimoMaximo(centroides, parametro.getNumeroPlanos(), parametroCorrespondence);
                break;
            }
            case PERIMETER: {
                areas = calculo.getPerimetroCurvas(parametro.getPlanos());
                distanciasVO = calculo.getDeltaPlusMinimoMaximo(centroides, parametro.getNumeroPlanos(), parametroCorrespondence);
            }
        }
        t2 = System.currentTimeMillis();
        this.log.warning("Tempo de definir dist\u00e2ncia m\u00e1xima e m\u00ednima: " + (t2 - t1) + " milisegundos");
        double calc1 = distanciasVO.getMaximo() - distanciasVO.getMinimo();
        double calc2 = parametroCorrespondence.getDelta() / 100.0;
        double deltaDefault = calc1 * calc2 + distanciasVO.getMinimo();
        if (deltaDefault < distanciasVO.getMinimo()) {
            this.converter.gerarPlanos(parametro);
        } else {
            Iterator<double[][]> it = distanciasVO.getDistanciasCollection().iterator();
            t1 = System.currentTimeMillis();
            double deltaCalculed = 0.0;
            Double[][] areasCalc = areas.getAreas();
            Double range = parametroCorrespondence.getRange() / 100.0;
            int i = 0;
            while (it.hasNext()) {
                double[][] distancias = it.next();
                int a = 0;
                while (a < distancias.length) {
                    int b = 0;
                    while (b < distancias[a].length) {
                        if (!parametroCorrespondence.getCorrespondenceAreaType().equals((Object)CorrespondenceAreaTypeEnum.DEFAULT_DELTA)) {
                            double numerator = areasCalc[i][a] * areasCalc[i + 1][b] - Math.pow(areas.getMinimo(), 2.0);
                            double divisor = Math.pow(areas.getMaximo(), 2.0) - Math.pow(areas.getMinimo(), 2.0);
                            double areaRelation = numerator / divisor;
                            deltaCalculed = deltaDefault + range * areaRelation;
                        } else {
                            deltaCalculed = deltaDefault;
                        }
                        if (distancias[a][b] <= deltaCalculed) {
                            int numeroPontosTiling = this.tiling(parametro.getPlanos()[i][a], parametro.getPlanos()[i + 1][b], parametroTiling);
                            this.numeroPontosGerados += numeroPontosTiling - (parametro.getPlanos()[i][a].length + parametro.getPlanos()[i + 1][b].length);
                        } else {
                            this.converter.gerarFace(parametro.getPlanos()[i][a]);
                            this.converter.gerarFace(parametro.getPlanos()[i + 1][b]);
                        }
                        ++b;
                    }
                    ++a;
                }
                ++i;
            }
            t2 = System.currentTimeMillis();
            this.log.warning("Tempo total tiling: " + (t2 - t1) + " milisegundos");
            JOptionPane.showMessageDialog(null, "\n N\u00famero de pontos antes da Interpola\u00e7\u00e3o: " + parametro.getNumeroInicialTotalPontos() + "\n\n" + " N\u00famero de pontos criados: " + this.numeroPontosGerados + "\n\n" + " N\u00famero de pontos ap\u00f3s da Interpola\u00e7\u00e3o: " + (this.numeroPontosGerados + parametro.getNumeroInicialTotalPontos()), "Resultado", 1);
            this.imprimeTempo();
        }
    }

    private int tiling(float[][] curva1, float[][] curva2, TileInterfaceParameter parametroTiling) {
        long t1 = System.currentTimeMillis();
        long t2 = System.currentTimeMillis();
        int numeroTotalPontos = 0;
        float[][] novaCurva1 = new float[numeroTotalPontos][3];
        float[][] novaCurva2 = new float[numeroTotalPontos][3];
        CalculoAuxiliar calculo = new CalculoAuxiliar();
        int posicaoCurva1 = 0;
        int posicaoCurva2 = 0;
        int[] posicoesPontoInicial = null;
        float[] centroideCurva1 = null;
        float[] centroideCurva2 = null;
        float distX = 0.0f;
        float distY = 0.0f;
        t1 = System.currentTimeMillis();
        if (parametroTiling.getOffsetOption() != null) {
            switch (parametroTiling.getOffsetOption()) {
                case BOUNDING_CIRCLE: {
                    centroideCurva1 = calculo.getCentroideBoundingCircle(curva1);
                    centroideCurva2 = calculo.getCentroideBoundingCircle(curva2);
                    distX = centroideCurva2[0] - centroideCurva1[0];
                    distY = centroideCurva2[1] - centroideCurva1[1];
                    int i = 0;
                    while (i < curva2.length) {
                        curva2[i][0] = curva2[i][0] - distX;
                        curva2[i][1] = curva2[i][1] - distY;
                        ++i;
                    }
                    break;
                }
                case MEDIA_EXTREMOS_X_Y: {
                    centroideCurva1 = calculo.getCentroideMediaExtremosXY(curva1);
                    centroideCurva2 = calculo.getCentroideMediaExtremosXY(curva2);
                    distX = centroideCurva2[0] - centroideCurva1[0];
                    distY = centroideCurva2[1] - centroideCurva1[1];
                    int i = 0;
                    while (i < curva2.length) {
                        curva2[i][0] = curva2[i][0] - distX;
                        curva2[i][1] = curva2[i][1] - distY;
                        ++i;
                    }
                    break;
                }
                case MEDIA_TODOS_PONTOS: {
                    centroideCurva1 = calculo.getCentroideMediaTodosPontosXY(curva1);
                    centroideCurva2 = calculo.getCentroideMediaTodosPontosXY(curva2);
                    distX = centroideCurva2[0] - centroideCurva1[0];
                    distY = centroideCurva2[1] - centroideCurva1[1];
                    int i = 0;
                    while (i < curva2.length) {
                        curva2[i][0] = curva2[i][0] - distX;
                        curva2[i][1] = curva2[i][1] - distY;
                        ++i;
                    }
                    break;
                }
            }
        }
        t2 = System.currentTimeMillis();
        this.tempoOffSetting += t2 - t1;
        t1 = System.currentTimeMillis();
        switch (parametroTiling.getBalanceOption()) {
            case ANZOLIN: {
                numeroTotalPontos = curva1.length + curva2.length;
                novaCurva1 = calculo.adicionaMNPontos(curva1, numeroTotalPontos);
                novaCurva2 = calculo.adicionaMNPontos(curva2, numeroTotalPontos);
                break;
            }
            case EXTENSAO_ANZOLIN: {
                if (curva1.length > curva2.length) {
                    numeroTotalPontos = curva1.length;
                    novaCurva1 = curva1;
                    novaCurva2 = calculo.adicionaMNPontos(curva2, curva1.length);
                    break;
                }
                numeroTotalPontos = curva2.length;
                novaCurva1 = calculo.adicionaMNPontos(curva1, curva2.length);
                novaCurva2 = curva2;
                break;
            }
            case DIST_PROP_LOCAL: {
                if (curva1.length != curva2.length) {
                    if (curva1.length > curva2.length) {
                        novaCurva1 = curva1;
                        novaCurva2 = calculo.distribuicaoProporcionalLocal(curva1, curva2);
                        numeroTotalPontos = novaCurva1.length;
                        break;
                    }
                    novaCurva1 = calculo.distribuicaoProporcionalLocal(curva2, curva1);
                    novaCurva2 = curva2;
                    numeroTotalPontos = novaCurva1.length;
                    break;
                }
                novaCurva1 = curva1;
                novaCurva2 = curva2;
                numeroTotalPontos = novaCurva1.length;
                break;
            }
            case DIST_PROP_LOCAL_ADAPTADA: {
                break;
            }
            case DIST_PROP_LOCAL_EXTENTIDA: {
                Vector<float[][]> vCurvas = calculo.distribuicaoProporcionalAdaptada(curva1, curva2);
                novaCurva1 = vCurvas.get(0);
                novaCurva2 = vCurvas.get(1);
                numeroTotalPontos = novaCurva1.length;
                break;
            }
            case DIST_CEGA: {
                if (curva1.length > curva2.length) {
                    numeroTotalPontos = curva1.length;
                    novaCurva1 = curva1;
                    novaCurva2 = calculo.distribuicaoCega(curva2, numeroTotalPontos);
                    break;
                }
                numeroTotalPontos = curva2.length;
                novaCurva1 = calculo.adicionaMNPontos(curva1, numeroTotalPontos);
                novaCurva2 = curva2;
                break;
            }
            case SEM_BALANCEAMENTO: {
                novaCurva1 = curva1;
                novaCurva2 = curva2;
            }
        }
        t2 = System.currentTimeMillis();
        this.tempoBalancing += t2 - t1;
        t1 = System.currentTimeMillis();
        if (parametroTiling.getOffsetOption() != null) {
            int i = 0;
            while (i < novaCurva2.length) {
                novaCurva2[i][0] = novaCurva2[i][0] + distX;
                novaCurva2[i][1] = novaCurva2[i][1] + distY;
                ++i;
            }
        }
        t2 = System.currentTimeMillis();
        this.tempoOffSetting += t2 - t1;
        t1 = System.currentTimeMillis();
        switch (parametroTiling.getFirstPointOption()) {
            case PONTO_AUXILIAR: {
                posicoesPontoInicial = calculo.getIndicePontoOrigemPontoAuxiliar(novaCurva1, novaCurva2);
                break;
            }
            case PROXIMO_2D: {
                posicoesPontoInicial = calculo.getIndicePontoOrigemMenorDistancia2D(novaCurva1, novaCurva2);
                break;
            }
            case PROXIMO_3D: {
                posicoesPontoInicial = calculo.getIndicePontoOrigemMenorDistancia3D(novaCurva1, novaCurva2);
            }
        }
        posicaoCurva1 = posicoesPontoInicial[0];
        posicaoCurva2 = posicoesPontoInicial[1];
        t2 = System.currentTimeMillis();
        this.tempoFirstPoint += t2 - t1;
        t1 = System.currentTimeMillis();
        switch (parametroTiling.getReorderOption()) {
            case INDICE: {
                novaCurva1 = calculo.ordenaPontoOrigemFuncao(novaCurva1, posicaoCurva1);
                novaCurva2 = calculo.ordenaPontoOrigemFuncao(novaCurva2, posicaoCurva2);
                break;
            }
            case FORCA_BRUTA: {
                novaCurva1 = calculo.ordenaPontoOrigemForcaBruta(novaCurva1, posicaoCurva1);
                novaCurva2 = calculo.ordenaPontoOrigemForcaBruta(novaCurva2, posicaoCurva2);
                break;
            }
        }
        t2 = System.currentTimeMillis();
        this.tempoReordering += t2 - t1;
        String geometria = new String();
        String topologia = new String();
        t1 = System.currentTimeMillis();
        switch (parametroTiling.getLinkingOption()) {
            case TRIANGULAR: {
                geometria = calculo.geraGeometriaAnzolin(novaCurva1, novaCurva2, numeroTotalPontos);
                topologia = calculo.geraTopologiaTriangular(numeroTotalPontos);
                break;
            }
            case QUADRANGULAR: {
                geometria = calculo.geraGeometriaAnzolin(novaCurva1, novaCurva2, numeroTotalPontos);
                topologia = calculo.geraTopologiaQuadrangular(numeroTotalPontos);
                break;
            }
            case INDICE: {
                geometria = calculo.geraGeometriaPorIndice(novaCurva1, novaCurva2);
                topologia = calculo.geraTopologiaPorIndice(novaCurva1.length, novaCurva2.length);
                break;
            }
            case DIST_2D: {
                geometria = calculo.geraGeometriaAnzolin(novaCurva1, novaCurva2, numeroTotalPontos);
                topologia = calculo.geraTopologiaR2(novaCurva1, novaCurva2);
                break;
            }
            case DIST_3D: {
                geometria = calculo.geraGeometriaAnzolin(novaCurva1, novaCurva2, numeroTotalPontos);
                topologia = calculo.geraTopologiaR3(novaCurva1, novaCurva2);
            }
        }
        t2 = System.currentTimeMillis();
        this.tempoLinking += t2 - t1;
        this.metrica.metricaSpan(topologia, geometria, parametroTiling.getLinkingOption());
        this.metrica.metricaSomaSpanSegmento(topologia, geometria, parametroTiling.getLinkingOption());
        this.converter.escreverFacesVRML(geometria, topologia);
        return novaCurva1.length + novaCurva2.length;
    }

    public void imprimeTempo() {
        JOptionPane.showMessageDialog(null, "Tempo OffSetting: " + this.tempoOffSetting + " milseg \n" + "Tempo First Point: " + this.tempoFirstPoint + " milseg \n" + "Tempo Reordering: " + this.tempoReordering + " milseg \n" + "Tempo Balancing: " + this.tempoBalancing + " milseg \n" + "Tempo Linking: " + this.tempoLinking + " milseg \n" + "Tempo TOTAL: " + (this.tempoFirstPoint + this.tempoReordering + this.tempoBalancing + this.tempoOffSetting + this.tempoLinking) + " milseg \n", "Resultado do Tempo", 1);
    }
}

