/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.interpolation;

import com.udesc.larva.delta.interpolation.AreasVO;
import com.udesc.larva.delta.interpolation.DistanciasVO;
import com.udesc.larva.delta.ui.vo.CorrespondenceFxTypeEnum;
import com.udesc.larva.delta.ui.vo.CorrespondenceInterfaceParameter;
import com.udesc.larva.delta.ui.vo.OffsetOptionEnum;
import java.util.Arrays;
import java.util.Vector;

public class CalculoAuxiliar {
    private AreasVO getMinMaxArea(AreasVO areas) {
        Double[][] doubleArray = areas.getAreas();
        int n = doubleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Double[] slices;
            Double[] doubleArray2 = slices = doubleArray[n2];
            int n3 = slices.length;
            int n4 = 0;
            while (n4 < n3) {
                Double area = doubleArray2[n4];
                if (areas.getMinimo() == null) {
                    areas.setMinimo(area);
                } else if (areas.getMinimo() > area) {
                    areas.setMinimo(area);
                }
                if (areas.getMaximo() == null) {
                    areas.setMaximo(area);
                } else if (areas.getMaximo() < area) {
                    areas.setMaximo(area);
                }
                ++n4;
            }
            ++n2;
        }
        return areas;
    }

    public AreasVO getBoundingCircleAreas(float[][][][] planos) {
        AreasVO areasVO = new AreasVO();
        double area = 0.0;
        Double[][] areas = new Double[planos.length][];
        int i = 0;
        while (i < planos.length) {
            areas[i] = new Double[planos[i].length];
            int j = 0;
            while (j < planos[i].length) {
                area = this.getBoundingCircleArea(planos[i][j]);
                areas[i][j] = area;
                ++j;
            }
            ++i;
        }
        areasVO.setAreas(areas);
        areasVO = this.getMinMaxArea(areasVO);
        return areasVO;
    }

    public double getBoundingCircleArea(float[][] curva) {
        float[] pontoMax1 = null;
        float[] pontoMax2 = null;
        double distanciaMax = 0.0;
        float[][] fArray = curva;
        int n = curva.length;
        int n2 = 0;
        while (n2 < n) {
            float[] fs = fArray[n2];
            float[][] fArray2 = curva;
            int n3 = curva.length;
            int n4 = 0;
            while (n4 < n3) {
                float[] f = fArray2[n4];
                double distancia = this.getDistancia2DEntrePontos(fs, f);
                if (distancia > distanciaMax) {
                    distanciaMax = distancia;
                    pontoMax1 = fs;
                    pontoMax2 = f;
                }
                ++n4;
            }
            ++n2;
        }
        double diametro = this.getDistancia2DEntrePontos(pontoMax1, pontoMax2);
        double area = Math.PI * Math.pow(diametro / 2.0, 2.0);
        return area;
    }

    public AreasVO getAreaCurvasBoundingBox(float[][][][] planos) {
        AreasVO areasVO = new AreasVO();
        double area = 0.0;
        Double[][] areas = new Double[planos.length][];
        int i = 0;
        while (i < planos.length) {
            areas[i] = new Double[planos[i].length];
            int j = 0;
            while (j < planos[i].length) {
                area = this.getBoundingBoxArea(planos[i][j]);
                areas[i][j] = area;
                ++j;
            }
            ++i;
        }
        areasVO.setAreas(areas);
        areasVO = this.getMinMaxArea(areasVO);
        return areasVO;
    }

    public Double getBoundingBoxArea(float[][] curve) {
        float[] leftBottomPoint = null;
        float[] rightBottomPoint = null;
        float[] leftUpPoint = null;
        float[] rightUpPoint = null;
        float[][] fArray = curve;
        int n = curve.length;
        int n2 = 0;
        while (n2 < n) {
            float[] fs = fArray[n2];
            if (leftBottomPoint == null) {
                leftBottomPoint = Arrays.copyOf(fs, 3);
            }
            if (rightBottomPoint == null) {
                rightBottomPoint = Arrays.copyOf(fs, 3);
            }
            if (leftUpPoint == null) {
                leftUpPoint = Arrays.copyOf(fs, 3);
            }
            if (rightUpPoint == null) {
                rightUpPoint = Arrays.copyOf(fs, 3);
            }
            if (fs[0] < leftBottomPoint[0]) {
                leftBottomPoint[0] = fs[0];
            }
            if (fs[1] < leftBottomPoint[1]) {
                leftBottomPoint[1] = fs[1];
            }
            if (fs[0] < leftUpPoint[0]) {
                leftUpPoint[0] = fs[0];
            }
            if (fs[1] > leftUpPoint[1]) {
                leftUpPoint[1] = fs[1];
            }
            if (fs[0] > rightBottomPoint[0]) {
                rightBottomPoint[0] = fs[0];
            }
            if (fs[1] < rightBottomPoint[1]) {
                rightBottomPoint[1] = fs[1];
            }
            if (fs[0] > rightUpPoint[0]) {
                rightUpPoint[0] = fs[0];
            }
            if (fs[1] > leftBottomPoint[1]) {
                rightUpPoint[1] = fs[1];
            }
            ++n2;
        }
        double width = this.getDistancia2DEntrePontos(leftBottomPoint, rightBottomPoint);
        double height = this.getDistancia2DEntrePontos(leftBottomPoint, leftUpPoint);
        double area = width * height;
        return area;
    }

    public AreasVO getPerimetroCurvas(float[][][][] planos) {
        AreasVO areasVO = new AreasVO();
        double perimetro = 0.0;
        Double[][] perimetros = new Double[planos.length][];
        int i = 0;
        while (i < planos.length) {
            perimetros[i] = new Double[planos[i].length];
            int j = 0;
            while (j < planos[i].length) {
                int k = 0;
                while (k < planos[i][j].length - 1) {
                    float[] pt1 = planos[i][j][k];
                    float[] pt2 = planos[i][j][k + 1];
                    perimetro += this.getDistancia2DEntrePontos(pt1, pt2);
                    ++k;
                }
                perimetros[i][j] = perimetro;
                ++j;
            }
            ++i;
        }
        areasVO.setAreas(perimetros);
        areasVO = this.getMinMaxArea(areasVO);
        return areasVO;
    }

    public double[][][] getCentroides(float[][][][] planos, OffsetOptionEnum offsetEnum) {
        float[] centroide = null;
        double[][][] centroides = new double[planos.length][][];
        int i = 0;
        while (i < planos.length) {
            centroides[i] = new double[planos[i].length][3];
            int j = 0;
            while (j < planos[i].length) {
                switch (offsetEnum) {
                    case MEDIA_EXTREMOS_X_Y: {
                        centroide = this.getCentroideMediaExtremosXY(planos[i][j]);
                        break;
                    }
                    case BOUNDING_CIRCLE: {
                        centroide = this.getCentroideBoundingCircle(planos[i][j]);
                        break;
                    }
                    case MEDIA_TODOS_PONTOS: {
                        centroide = this.getCentroideMediaTodosPontosXY(planos[i][j]);
                    }
                }
                centroides[i][j][0] = centroide[0];
                centroides[i][j][1] = centroide[1];
                centroides[i][j][2] = centroide[2];
                ++j;
            }
            ++i;
        }
        return centroides;
    }

    public float[] getCentroideBoundingCircle(float[][] curva) {
        float[] pontoMax1 = null;
        float[] pontoMax2 = null;
        double distanciaMax = 0.0;
        float[][] fArray = curva;
        int n = curva.length;
        int n2 = 0;
        while (n2 < n) {
            float[] fs = fArray[n2];
            float[][] fArray2 = curva;
            int n3 = curva.length;
            int n4 = 0;
            while (n4 < n3) {
                float[] f = fArray2[n4];
                double distancia = this.getDistancia2DEntrePontos(fs, f);
                if (distancia > distanciaMax) {
                    distanciaMax = distancia;
                    pontoMax1 = fs;
                    pontoMax2 = f;
                }
                ++n4;
            }
            ++n2;
        }
        float[] centroide = new float[3];
        if (pontoMax1 != null && pontoMax2 != null) {
            centroide[0] = (pontoMax1[0] + pontoMax2[0]) / 2.0f;
            centroide[1] = (pontoMax1[1] + pontoMax2[1]) / 2.0f;
            centroide[2] = pontoMax1[2];
        }
        return centroide;
    }

    public float[] getCentroideMediaExtremosXY(float[][] curva) {
        float[] min = new float[]{curva[0][0], curva[0][1]};
        float[] max = new float[]{curva[0][0], curva[0][1]};
        float[] centroide = new float[3];
        int i = 0;
        while (i < curva.length) {
            if (min[0] > curva[i][0]) {
                min[0] = curva[i][0];
            }
            if (max[0] < curva[i][0]) {
                max[0] = curva[i][0];
            }
            if (min[1] > curva[i][1]) {
                min[1] = curva[i][1];
            }
            if (max[1] < curva[i][1]) {
                max[1] = curva[i][1];
            }
            ++i;
        }
        centroide[0] = (min[0] + max[0]) / 2.0f;
        centroide[1] = (min[1] + max[1]) / 2.0f;
        centroide[2] = curva[0][2];
        return centroide;
    }

    public float[] getCentroideMediaTodosPontosXY(float[][] curva) {
        float totalX = 0.0f;
        float totalY = 0.0f;
        float[] centroide = new float[3];
        int i = 0;
        while (i < curva.length) {
            totalX += curva[i][0];
            totalY += curva[i][1];
            ++i;
        }
        centroide[0] = totalX / (float)curva.length;
        centroide[1] = totalY / (float)curva.length;
        centroide[2] = curva[0][2];
        return centroide;
    }

    public double[][] matrizDeDistancias(double[][] centroidesP1, double[][] centroidesP2) {
        double[][] dist = new double[centroidesP1.length][centroidesP2.length];
        int i = 0;
        while (i < centroidesP1.length) {
            int j = 0;
            while (j < centroidesP2.length) {
                dist[i][j] = Math.pow(centroidesP1[i][0] - centroidesP2[j][0], 2.0) + Math.pow(centroidesP1[i][1] - centroidesP2[j][1], 2.0);
                ++j;
            }
            ++i;
        }
        return dist;
    }

    public double[][] matrizDeDistanciasPlus(double[][] centroidesP1, double[][] centroidesP2, CorrespondenceInterfaceParameter correspondenceParameter) {
        double distancia = 0.0;
        double[][] plus = new double[centroidesP1.length][centroidesP2.length];
        int i = 0;
        while (i < centroidesP1.length) {
            int j = 0;
            while (j < centroidesP2.length) {
                switch (correspondenceParameter.getDistanceType()) {
                    case R2: {
                        distancia = Math.pow(centroidesP1[i][0] - centroidesP2[j][0], 2.0) + Math.pow(centroidesP1[i][1] - centroidesP2[j][1], 2.0);
                        break;
                    }
                    case R3: {
                        distancia = Math.pow(centroidesP1[i][0] - centroidesP2[j][0], 2.0) + Math.pow(centroidesP1[i][1] - centroidesP2[j][1], 2.0) + Math.pow(centroidesP1[i][2] - centroidesP2[j][2], 2.0);
                    }
                }
                plus[i][j] = distancia;
                ++j;
            }
            ++i;
        }
        return plus;
    }

    private double getRelacaoAreas(double area1, double area2, CorrespondenceFxTypeEnum fxEnum) {
        if (fxEnum == null) {
            return 1.0;
        }
        if (fxEnum.equals((Object)CorrespondenceFxTypeEnum.PLUS)) {
            return area1 + area2;
        }
        return area1 * area2;
    }

    public double getDistanciaMinima(double[][] distancias) {
        double min = distancias[0][0];
        int i = 0;
        while (i < distancias.length) {
            int j = 0;
            while (j < distancias[i].length) {
                if (distancias[i][j] < min) {
                    min = distancias[i][j];
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public double getDistanciaMaxima(double[][] distancias) {
        double max = distancias[0][0];
        int i = 0;
        while (i < distancias.length) {
            int j = 0;
            while (j < distancias[i].length) {
                if (distancias[i][j] > max) {
                    max = distancias[i][j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public double getDistancia2DEntrePontos(float[] ponto1, float[] ponto2) {
        return Math.sqrt(Math.pow(ponto1[0] - ponto2[0], 2.0) + Math.pow(ponto1[1] - ponto2[1], 2.0));
    }

    public double getDistancia3DEntrePontos(float[] ponto1, float[] ponto2) {
        return Math.sqrt(Math.pow(ponto1[0] - ponto2[0], 2.0) + Math.pow(ponto1[1] - ponto2[1], 2.0) + Math.pow(ponto1[2] - ponto2[2], 2.0));
    }

    public double getDistancia2DEntrePontos(double[] ponto1, double[] ponto2) {
        return Math.sqrt(Math.pow(ponto1[0] - ponto2[0], 2.0) + Math.pow(ponto1[1] - ponto2[1], 2.0));
    }

    public double getDistancia3DEntrePontos(double[] ponto1, double[] ponto2) {
        return Math.sqrt(Math.pow(ponto1[0] - ponto2[0], 2.0) + Math.pow(ponto1[1] - ponto2[1], 2.0) + Math.pow(ponto1[2] - ponto2[2], 2.0));
    }

    public float[] getPontoMedio(float[] ponto1, float[] ponto2) {
        float[] pMedio = new float[]{(ponto1[0] + ponto2[0]) / 2.0f, (ponto1[1] + ponto2[1]) / 2.0f, ponto1[2]};
        return pMedio;
    }

    public float[][] ordenaPontoOrigemForcaBruta(float[][] curva, int pos) {
        float[][] aux = new float[1][];
        int i = 0;
        while (i < pos) {
            aux[0] = curva[0];
            int j = 0;
            while (j < curva.length - 1) {
                curva[j] = curva[j + 1];
                ++j;
            }
            curva[curva.length - 1] = aux[i];
            ++i;
        }
        return curva;
    }

    public float[][] ordenaPontoOrigemFuncao(float[][] curva, int pos) {
        float[][] listaAux = new float[curva.length][3];
        int cont = 0;
        int i = pos;
        while (i < curva.length) {
            listaAux[cont] = curva[i];
            ++cont;
            ++i;
        }
        i = 0;
        while (i < pos) {
            listaAux[cont] = curva[i];
            ++cont;
            ++i;
        }
        return listaAux;
    }

    public int[] getIndicePontoOrigemMenorDistancia2D(float[][] curva1, float[][] curva2) {
        int posC1 = 0;
        int posC2 = 0;
        double menorDistancia = 0.0;
        int i = 0;
        while (i < curva1.length) {
            int j = 0;
            while (j < curva2.length) {
                double distancia = this.getDistancia2DEntrePontos(curva1[i], curva2[j]);
                if (menorDistancia == 0.0 || menorDistancia > distancia) {
                    menorDistancia = distancia;
                    posC1 = i;
                    posC2 = j;
                }
                ++j;
            }
            ++i;
        }
        int[] result = new int[]{posC1, posC2};
        return result;
    }

    public int[] getIndicePontoOrigemMenorDistancia3D(float[][] curva1, float[][] curva2) {
        int posC1 = 0;
        int posC2 = 0;
        double menorDistancia = 0.0;
        int i = 0;
        while (i < curva1.length) {
            int j = 0;
            while (j < curva2.length) {
                double distancia = this.getDistancia3DEntrePontos(curva1[i], curva2[j]);
                if (menorDistancia == 0.0 || menorDistancia > distancia) {
                    menorDistancia = distancia;
                    posC1 = i;
                    posC2 = j;
                }
                ++j;
            }
            ++i;
        }
        int[] result = new int[]{posC1, posC2};
        return result;
    }

    public int[] getIndicePontoOrigemPontoAuxiliar(float[][] curva1, float[][] curva2) {
        float xAux = 0.0f;
        float yAux = 0.0f;
        float zAux = 0.0f;
        double dist = 999999.0;
        double dist2 = 999999.0;
        int posC1 = 0;
        int posC2 = 0;
        float[] pontoAux = new float[3];
        float[] pontoRefC1 = new float[3];
        int i = 0;
        while (i < curva1.length) {
            pontoAux = curva1[i];
            if (xAux == 0.0f || xAux > pontoAux[0]) {
                xAux = pontoAux[0];
            }
            if (yAux == 0.0f || yAux > pontoAux[1]) {
                yAux = pontoAux[1];
            }
            if (zAux == 0.0f || zAux > pontoAux[2]) {
                zAux = pontoAux[2];
            }
            ++i;
        }
        i = 0;
        while (i < curva2.length) {
            pontoAux = curva2[i];
            if (xAux == 0.0f || xAux > pontoAux[0]) {
                xAux = pontoAux[0];
            }
            if (yAux == 0.0f || yAux > pontoAux[1]) {
                yAux = pontoAux[1];
            }
            if (zAux == 0.0f || zAux > pontoAux[2]) {
                zAux = pontoAux[2];
            }
            ++i;
        }
        pontoRefC1[0] = xAux;
        pontoRefC1[1] = yAux;
        pontoRefC1[2] = zAux;
        i = 0;
        while (i < curva1.length) {
            pontoAux = curva1[i];
            double distAux = this.getDistancia2DEntrePontos(pontoAux, pontoRefC1);
            if (distAux < dist) {
                posC1 = i;
                dist = distAux;
            }
            ++i;
        }
        i = 0;
        while (i < curva2.length) {
            pontoAux = curva2[i];
            double distAux2 = this.getDistancia2DEntrePontos(pontoAux, pontoRefC1);
            if (distAux2 < dist2) {
                posC2 = i;
                dist2 = distAux2;
            }
            ++i;
        }
        int[] result = new int[]{posC1, posC2};
        return result;
    }

    public float[][] adicionaMNPontos(float[][] curva, int quantidadeTotalPontos) {
        int vizinhoAnt = 0;
        float[][] curvaAux = new float[quantidadeTotalPontos][3];
        float[][] novaCurva = new float[quantidadeTotalPontos][3];
        int cont = 0;
        while (cont < curva.length) {
            novaCurva[cont] = curva[cont];
            ++cont;
        }
        int pt = 0;
        while (pt < quantidadeTotalPontos - curva.length) {
            double distancia = 0.0;
            int l = 0;
            l = 0;
            while (l < curva.length + pt - 1) {
                if (this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[l + 1]) > distancia) {
                    distancia = this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[l + 1]);
                    vizinhoAnt = l;
                }
                ++l;
            }
            if (this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[0]) > distancia) {
                vizinhoAnt = l;
            }
            int j = 0;
            while (j < quantidadeTotalPontos) {
                curvaAux[j] = novaCurva[j];
                ++j;
            }
            j = 0;
            while (j <= vizinhoAnt) {
                novaCurva[j] = curvaAux[j];
                ++j;
            }
            novaCurva[vizinhoAnt + 1] = vizinhoAnt == curva.length + pt - 1 ? this.getPontoMedio(curvaAux[vizinhoAnt], curvaAux[0]) : this.getPontoMedio(curvaAux[vizinhoAnt], curvaAux[vizinhoAnt + 1]);
            j = vizinhoAnt + 2;
            while (j < curva.length + pt + 1) {
                novaCurva[j] = curvaAux[j - 1];
                ++j;
            }
            ++pt;
        }
        return novaCurva;
    }

    public String geraTopologiaTriangular(int numeroTotalPontos) {
        String topologia = "";
        int tam = numeroTotalPontos * 2;
        int i = 0;
        while (i < tam) {
            topologia = String.valueOf(topologia) + i + " " + (i > tam - 2 ? (i + 1) % tam : (i + 1) % tam) + " " + (i > tam - 3 ? (i + 2) % tam : (i + 2) % tam) + " -1  ";
            ++i;
        }
        topologia = String.valueOf(topologia) + "\n\r";
        return topologia;
    }

    public String geraTopologiaQuadrangular(int numeroTotalPontos) {
        String topologia = "";
        int tam = numeroTotalPontos * 2;
        int i = 0;
        while (i < tam - 1) {
            topologia = String.valueOf(topologia) + i + " " + (i > tam - 2 ? (i + 1) % tam : (i + 1) % tam) + " " + (i > tam - 3 ? (i + 3) % tam : (i + 3) % tam) + " " + (i > tam - 4 ? (i + 2) % tam : (i + 2) % tam) + " -1  ";
            ++i;
            ++i;
        }
        topologia = String.valueOf(topologia) + "\n\r";
        return topologia;
    }

    public String geraTopologiaR2(float[][] curva1, float[][] curva2) {
        String topologia = "";
        int posCurva1 = 0;
        int posCurva2 = 0;
        Vector<int[]> correspondecias = new Vector<int[]>();
        int[] cor_temp = new int[]{0, 1};
        int[] x = new int[]{cor_temp[0], cor_temp[1]};
        correspondecias.add(x);
        int tam = curva1.length + curva2.length;
        int k = 0;
        while (k < tam) {
            double distanciaNM;
            double distanciaMN = this.getDistancia2DEntrePontos(curva1[posCurva1], curva2[posCurva2 >= curva2.length - 1 ? 0 : posCurva2 + 1]);
            if (distanciaMN <= (distanciaNM = this.getDistancia2DEntrePontos(curva2[posCurva2], curva1[posCurva1 >= curva1.length - 1 ? 0 : posCurva1 + 1]))) {
                int id_m = posCurva1 * 2;
                int id_n = (posCurva2 + 1) * 2 + 1;
                if (id_n >= tam) {
                    id_n -= tam;
                }
                cor_temp[0] = id_m;
                cor_temp[1] = id_n;
                ++posCurva2;
            }
            if (distanciaNM < distanciaMN) {
                int id_n = posCurva2 * 2 + 1;
                int id_m = (posCurva1 + 1) * 2;
                if (id_m >= tam) {
                    id_m -= tam;
                }
                cor_temp[0] = id_n;
                cor_temp[1] = id_m;
                ++posCurva1;
            }
            int[] t = new int[]{cor_temp[0], cor_temp[1]};
            correspondecias.add(t);
            if (posCurva1 >= curva1.length) {
                posCurva1 = 0;
            }
            if (posCurva2 >= curva2.length) {
                posCurva2 = 0;
            }
            ++k;
        }
        k = 0;
        while (k < correspondecias.size() - 1) {
            Vector<Integer> triangulo = new Vector<Integer>();
            int[] corAtu = new int[2];
            int[] corPro = new int[2];
            corAtu = (int[])correspondecias.elementAt(k);
            if (k + 2 == correspondecias.size()) {
                corPro = (int[])correspondecias.elementAt(0);
                triangulo.add(new Integer(corAtu[0]));
                triangulo.add(new Integer(corAtu[1]));
                triangulo.add(new Integer(corPro[0]));
            } else {
                corPro = (int[])correspondecias.elementAt(k + 1);
                triangulo.add(new Integer(corAtu[0]));
                triangulo.add(new Integer(corAtu[1]));
                triangulo.add(new Integer(corPro[1]));
            }
            topologia = String.valueOf(topologia) + triangulo.firstElement() + " " + triangulo.elementAt(1) + " " + triangulo.lastElement() + " -1  ";
            ++k;
        }
        return topologia;
    }

    public String geraTopologiaR3(float[][] curva1, float[][] curva2) {
        String topologia = "";
        int posCurva1 = 0;
        int posCurva2 = 0;
        Vector<int[]> correspondecias = new Vector<int[]>();
        int[] cor_temp = new int[]{0, 1};
        int[] x = new int[]{cor_temp[0], cor_temp[1]};
        correspondecias.add(x);
        int tam = curva1.length + curva2.length;
        int k = 0;
        while (k < tam) {
            double distanciaNM;
            double distanciaMN = this.getDistancia3DEntrePontos(curva1[posCurva1], curva2[posCurva2 >= curva2.length - 1 ? 0 : posCurva2 + 1]);
            if (distanciaMN <= (distanciaNM = this.getDistancia3DEntrePontos(curva2[posCurva2], curva1[posCurva1 >= curva1.length - 1 ? 0 : posCurva1 + 1]))) {
                int id_m = posCurva1 * 2;
                int id_n = (posCurva2 + 1) * 2 + 1;
                if (id_n >= tam) {
                    id_n -= tam;
                }
                cor_temp[0] = id_m;
                cor_temp[1] = id_n;
                ++posCurva2;
            }
            if (distanciaNM < distanciaMN) {
                int id_n = posCurva2 * 2 + 1;
                int id_m = (posCurva1 + 1) * 2;
                if (id_m >= tam) {
                    id_m -= tam;
                }
                cor_temp[0] = id_n;
                cor_temp[1] = id_m;
                ++posCurva1;
            }
            int[] t = new int[]{cor_temp[0], cor_temp[1]};
            correspondecias.add(t);
            if (posCurva1 >= curva1.length) {
                posCurva1 = 0;
            }
            if (posCurva2 >= curva2.length) {
                posCurva2 = 0;
            }
            ++k;
        }
        k = 0;
        while (k < correspondecias.size() - 1) {
            Vector<Integer> triangulo = new Vector<Integer>();
            int[] corAtu = new int[2];
            int[] corPro = new int[2];
            corAtu = (int[])correspondecias.elementAt(k);
            if (k + 2 == correspondecias.size()) {
                corPro = (int[])correspondecias.elementAt(0);
                triangulo.add(new Integer(corAtu[0]));
                triangulo.add(new Integer(corAtu[1]));
                triangulo.add(new Integer(corPro[0]));
            } else {
                corPro = (int[])correspondecias.elementAt(k + 1);
                triangulo.add(new Integer(corAtu[0]));
                triangulo.add(new Integer(corAtu[1]));
                triangulo.add(new Integer(corPro[1]));
            }
            topologia = String.valueOf(topologia) + triangulo.firstElement() + " " + triangulo.elementAt(1) + " " + triangulo.lastElement() + " -1  ";
            ++k;
        }
        return topologia;
    }

    public String geraGeometriaAnzolin(float[][] curva1, float[][] curva2, int numeroTotalPontos) {
        String ptsCurva = "";
        String geometria = "";
        ptsCurva = "";
        int k = 0;
        while (k < numeroTotalPontos) {
            ptsCurva = String.valueOf(ptsCurva) + curva1[k][0] + " " + curva1[k][2] + " " + curva1[k][1] + " , \r\n";
            ptsCurva = String.valueOf(ptsCurva) + curva2[k][0] + " " + curva2[k][2] + " " + curva2[k][1] + " , \r\n";
            ++k;
        }
        geometria = String.valueOf(geometria) + ptsCurva;
        return geometria;
    }

    public DistanciasVO getDeltaPlusMinimoMaximo(double[][][] centroides, int numeroPlanos, CorrespondenceInterfaceParameter correspondenceParameter) {
        DistanciasVO distanciasVO = new DistanciasVO();
        int i = 0;
        while (i < numeroPlanos - 1) {
            double[][] deltasPlus = this.matrizDeDistanciasPlus(centroides[i], centroides[i + 1], correspondenceParameter);
            distanciasVO.getDistanciasCollection().add(deltasPlus);
            double minimoAux = this.getDistanciaMinima(deltasPlus);
            double maximoAux = this.getDistanciaMaxima(deltasPlus);
            if (distanciasVO.getMinimo() == null) {
                distanciasVO.setMinimo(minimoAux);
            } else if (distanciasVO.getMinimo() > minimoAux) {
                distanciasVO.setMinimo(minimoAux);
            }
            if (distanciasVO.getMaximo() == null) {
                distanciasVO.setMaximo(maximoAux);
            } else if (distanciasVO.getMaximo() < maximoAux) {
                distanciasVO.setMaximo(maximoAux);
            }
            ++i;
        }
        return distanciasVO;
    }

    public DistanciasVO getDistanciaMinimaMaximaEEntrePlanos(double[][][] centroides, int numeroPlanos) {
        DistanciasVO distanciasVO = new DistanciasVO();
        int i = 0;
        while (i < numeroPlanos - 1) {
            double[][] distancias = this.matrizDeDistancias(centroides[i], centroides[i + 1]);
            distanciasVO.getDistanciasCollection().add(distancias);
            double minimoAux = this.getDistanciaMinima(distancias);
            double maximoAux = this.getDistanciaMaxima(distancias);
            if (distanciasVO.getMinimo() == null) {
                distanciasVO.setMinimo(minimoAux);
            } else if (distanciasVO.getMinimo() > minimoAux) {
                distanciasVO.setMinimo(minimoAux);
            }
            if (distanciasVO.getMaximo() == null) {
                distanciasVO.setMaximo(maximoAux);
            } else if (distanciasVO.getMaximo() < maximoAux) {
                distanciasVO.setMaximo(maximoAux);
            }
            ++i;
        }
        return distanciasVO;
    }

    public String geraTopologiaPorIndice(int tamanhoCurva1, int tamanhoCurva2) {
        String topologia = "";
        if (tamanhoCurva1 == tamanhoCurva2) {
            int tam = tamanhoCurva1 * 2;
            int i = 0;
            while (i < tam) {
                topologia = String.valueOf(topologia) + i + " " + (i > tam - 2 ? (i + 1) % tam : (i + 1) % tam) + " " + (i > tam - 3 ? (i + 2) % tam : (i + 2) % tam) + " -1  ";
                ++i;
            }
            topologia = String.valueOf(topologia) + "\n\r";
        } else {
            int contadorDePontosDaLinhaMaior;
            int numeroDeTriangulos = tamanhoCurva1 < tamanhoCurva2 ? tamanhoCurva2 / tamanhoCurva1 : tamanhoCurva1 / tamanhoCurva2;
            int resto = tamanhoCurva1 < tamanhoCurva2 ? tamanhoCurva2 % tamanhoCurva1 : tamanhoCurva1 % tamanhoCurva2;
            int n = contadorDePontosDaLinhaMaior = tamanhoCurva1 < tamanhoCurva2 ? tamanhoCurva1 : tamanhoCurva2;
            if (tamanhoCurva1 < tamanhoCurva2) {
                int i = 0;
                while (i < tamanhoCurva1) {
                    int j = 0;
                    while (j < numeroDeTriangulos) {
                        if (contadorDePontosDaLinhaMaior == tamanhoCurva1 + tamanhoCurva2 - 1) {
                            topologia = String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + tamanhoCurva1 + " -1  ";
                            contadorDePontosDaLinhaMaior = tamanhoCurva1;
                        } else {
                            topologia = String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + (contadorDePontosDaLinhaMaior + 1) + " -1  ";
                            ++contadorDePontosDaLinhaMaior;
                        }
                        ++j;
                    }
                    if (resto > 0) {
                        topologia = String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + (contadorDePontosDaLinhaMaior + 1) + " -1  ";
                        ++contadorDePontosDaLinhaMaior;
                        --resto;
                    }
                    topologia = i == tamanhoCurva1 - 1 ? String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + 0 + " -1  " : String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + (i + 1) + " -1  ";
                    ++i;
                }
            } else {
                int i = 0;
                while (i < tamanhoCurva2) {
                    int j = 0;
                    while (j < numeroDeTriangulos) {
                        if (contadorDePontosDaLinhaMaior == tamanhoCurva1 + tamanhoCurva2 - 1) {
                            topologia = String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + tamanhoCurva2 + " -1  ";
                            contadorDePontosDaLinhaMaior = tamanhoCurva2;
                        } else {
                            topologia = String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + (contadorDePontosDaLinhaMaior + 1) + " -1  ";
                            ++contadorDePontosDaLinhaMaior;
                        }
                        ++j;
                    }
                    if (resto > 0) {
                        topologia = String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + (contadorDePontosDaLinhaMaior + 1) + " -1  ";
                        ++contadorDePontosDaLinhaMaior;
                        --resto;
                    }
                    topologia = i == tamanhoCurva2 - 1 ? String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + 0 + " -1  " : String.valueOf(topologia) + i + " " + contadorDePontosDaLinhaMaior + " " + (i + 1) + " -1  ";
                    ++i;
                }
            }
        }
        return topologia;
    }

    public String geraGeometriaPorIndice(float[][] curva1, float[][] curva2) {
        String ptsCurva = "";
        String geometria = "";
        ptsCurva = "";
        if (curva1.length == curva2.length) {
            int k = 0;
            while (k < curva1.length) {
                ptsCurva = String.valueOf(ptsCurva) + curva1[k][0] + " " + curva1[k][2] + " " + curva1[k][1] + " , \r\n";
                ptsCurva = String.valueOf(ptsCurva) + curva2[k][0] + " " + curva2[k][2] + " " + curva2[k][1] + " , \r\n";
                ++k;
            }
            geometria = String.valueOf(geometria) + ptsCurva;
        } else if (curva1.length < curva2.length) {
            int i = 0;
            while (i < curva1.length) {
                geometria = String.valueOf(geometria) + curva1[i][0] + " " + curva1[i][2] + " " + curva1[i][1] + " , \r\n";
                ++i;
            }
            i = 0;
            while (i < curva2.length) {
                geometria = String.valueOf(geometria) + curva2[i][0] + " " + curva2[i][2] + " " + curva2[i][1] + " , \r\n";
                ++i;
            }
        } else {
            int i = 0;
            while (i < curva2.length) {
                geometria = String.valueOf(geometria) + curva2[i][0] + " " + curva2[i][2] + " " + curva2[i][1] + " , \r\n";
                ++i;
            }
            i = 0;
            while (i < curva1.length) {
                geometria = String.valueOf(geometria) + curva1[i][0] + " " + curva1[i][2] + " " + curva1[i][1] + " , \r\n";
                ++i;
            }
        }
        return geometria;
    }

    public Vector<Double> geraDistanciaProporcional(float[][] curva) {
        Vector<Double> T = new Vector<Double>();
        double distanciaTotal = 0.0;
        int k = 1;
        while (k <= curva.length) {
            distanciaTotal += this.getDistancia2DEntrePontos(curva[k - 1], curva[k >= curva.length ? 0 : k]);
            ++k;
        }
        double distanciaAtual = 0.0;
        double valor = 0.0;
        T.add(new Double(valor));
        int k2 = 1;
        while (k2 <= curva.length) {
            valor = (distanciaAtual += this.getDistancia2DEntrePontos(curva[k2 - 1], curva[k2 >= curva.length ? 0 : k2])) / distanciaTotal;
            T.add(new Double(valor));
            ++k2;
        }
        return T;
    }

    public float[][] distribuicaoProporcionalLocal(float[][] curva1, float[][] curva2) {
        float[][] novaCurva = new float[curva1.length][3];
        Vector<Object> T = new Vector();
        Vector<Object> S = new Vector();
        T = this.geraDistanciaProporcional(curva1);
        S = this.geraDistanciaProporcional(curva2);
        Vector<Integer> cor = new Vector<Integer>();
        int pontosNecessarios = curva1.length - curva2.length;
        int i = 0;
        while (i < S.size()) {
            double d = 1.0;
            int id = 0;
            int j = 0;
            while (j < T.size()) {
                double dTemp;
                if (!cor.contains(new Integer(j)) && (dTemp = Math.abs((Double)S.elementAt(i) - (Double)T.elementAt(j))) < d) {
                    d = dTemp;
                    id = j;
                }
                ++j;
            }
            if (id >= i) {
                cor.add(new Integer(id));
            }
            ++i;
        }
        Vector<float[]> curvaTemp = new Vector<float[]>();
        int i2 = 0;
        while (i2 < curva2.length) {
            curvaTemp.add(curva2[i2]);
            ++i2;
        }
        i2 = 1;
        while (i2 < cor.size()) {
            int pontosNec = (Integer)cor.elementAt(i2) - (Integer)cor.elementAt(i2 - 1);
            if (pontosNec >= 2) {
                int j = (Integer)cor.elementAt(i2 - 1) + 1;
                while (j < (Integer)cor.elementAt(i2)) {
                    if (pontosNecessarios == 0) break;
                    float[] novoPonto = new float[3];
                    int ini = i2 - 1;
                    int fim = i2 >= cor.size() - 1 ? 0 : i2;
                    double total = (Double)S.elementAt(fim) - (Double)S.elementAt(ini);
                    double parcial = (Double)T.elementAt(j) - (Double)T.elementAt((Integer)cor.elementAt(ini));
                    if (i2 >= cor.size() - 1) {
                        total = 1.0 - (Double)S.elementAt(ini);
                    }
                    double r = Math.abs(parcial / total);
                    novoPonto[0] = (float)(1.0 - r) * curva2[ini][0] + (float)r * curva2[fim][0];
                    novoPonto[1] = (float)(1.0 - r) * curva2[ini][1] + (float)r * curva2[fim][1];
                    novoPonto[2] = curva2[0][2];
                    curvaTemp.insertElementAt(novoPonto, j);
                    --pontosNecessarios;
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < curvaTemp.size()) {
            novaCurva[i2] = (float[])curvaTemp.elementAt(i2);
            ++i2;
        }
        return novaCurva;
    }

    public float[][] distribuicaoCega(float[][] curva, int quantidadeTotalPontos) {
        int vizinhoAnt = 0;
        float[][] curvaAux = new float[quantidadeTotalPontos][3];
        float[][] novaCurva = new float[quantidadeTotalPontos][3];
        int numeroDePontosEmCadaFace = quantidadeTotalPontos / curva.length;
        int contador = 0;
        int aresta = 0;
        while (aresta < curva.length) {
            novaCurva[contador] = curva[aresta];
            ++contador;
            int pontos = 0;
            while (pontos < numeroDePontosEmCadaFace - 1) {
                novaCurva[contador] = aresta == curva.length - 1 ? this.getXPontos(curva[aresta], curva[0], numeroDePontosEmCadaFace, pontos + 1) : this.getXPontos(curva[aresta], curva[aresta + 1], numeroDePontosEmCadaFace, pontos + 1);
                ++contador;
                ++pontos;
            }
            ++aresta;
        }
        int pt = 0;
        while (pt < quantidadeTotalPontos % curva.length) {
            double distancia = 0.0;
            int l = 0;
            l = 0;
            while (l < novaCurva.length - quantidadeTotalPontos % curva.length + pt - 1) {
                if (this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[l + 1]) > distancia) {
                    distancia = this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[l + 1]);
                    vizinhoAnt = l;
                }
                ++l;
            }
            if (this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[0]) > distancia) {
                vizinhoAnt = l;
            }
            int j = 0;
            while (j < quantidadeTotalPontos) {
                curvaAux[j] = novaCurva[j];
                ++j;
            }
            j = 0;
            while (j <= vizinhoAnt) {
                novaCurva[j] = curvaAux[j];
                ++j;
            }
            novaCurva[vizinhoAnt + 1] = vizinhoAnt == novaCurva.length + pt - 1 ? this.getPontoMedio(curvaAux[vizinhoAnt], curvaAux[0]) : this.getPontoMedio(curvaAux[vizinhoAnt], curvaAux[vizinhoAnt + 1]);
            j = vizinhoAnt + 2;
            while (j < novaCurva.length - quantidadeTotalPontos % curva.length + pt + 1) {
                novaCurva[j] = curvaAux[j - 1];
                ++j;
            }
            ++pt;
        }
        return novaCurva;
    }

    public float[] getXPontos(float[] ponto1, float[] ponto2, int x, int y) {
        float[] ponto = new float[]{ponto1[0] < ponto2[0] ? ponto1[0] + (float)y * (ponto2[0] - ponto1[0]) / (float)x : ponto2[0] + (float)y * (ponto1[0] - ponto2[0]) / (float)x, ponto1[1] < ponto2[1] ? ponto1[1] + (float)y * (ponto2[1] - ponto1[1]) / (float)x : ponto2[1] + (float)y * (ponto1[1] - ponto2[1]) / (float)x, ponto1[2]};
        return ponto;
    }

    public float[][] distribuicaoEnxuta(float[][] curva, int quantidadeTotalPontos) {
        int vizinhoAnt = 0;
        float[][] curvaAux = new float[quantidadeTotalPontos][3];
        float[][] novaCurva = new float[quantidadeTotalPontos][3];
        int cont = 0;
        while (cont < curva.length) {
            novaCurva[cont] = curva[cont];
            ++cont;
        }
        int pt = 0;
        while (pt < quantidadeTotalPontos - curva.length) {
            double distancia = 0.0;
            int l = 0;
            l = 0;
            while (l < curva.length + pt - 1) {
                if (this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[l + 1]) > distancia) {
                    distancia = this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[l + 1]);
                    vizinhoAnt = l;
                }
                ++l;
            }
            if (this.getDistancia2DEntrePontos(novaCurva[l], novaCurva[0]) > distancia) {
                vizinhoAnt = l;
            }
            int j = 0;
            while (j < quantidadeTotalPontos) {
                curvaAux[j] = novaCurva[j];
                ++j;
            }
            j = 0;
            while (j <= vizinhoAnt) {
                novaCurva[j] = curvaAux[j];
                ++j;
            }
            novaCurva[vizinhoAnt + 1] = vizinhoAnt == curva.length + pt - 1 ? this.getPontoMedio(curvaAux[vizinhoAnt], curvaAux[0]) : this.getPontoMedio(curvaAux[vizinhoAnt], curvaAux[vizinhoAnt + 1]);
            j = vizinhoAnt + 2;
            while (j < curva.length + pt + 1) {
                novaCurva[j] = curvaAux[j - 1];
                ++j;
            }
            ++pt;
        }
        return novaCurva;
    }

    public Vector<float[][]> distribuicaoProporcionalAdaptada(float[][] curva1, float[][] curva2) {
        Vector<float[]> vCurva1 = new Vector<float[]>();
        Vector<float[]> vCurva2 = new Vector<float[]>();
        Vector<float[][]> vetor = new Vector<float[][]>();
        Vector<Object> T = new Vector();
        Vector<Object> S = new Vector();
        int k = 0;
        while (k < curva1.length) {
            vCurva1.add(curva1[k]);
            ++k;
        }
        k = 0;
        while (k < curva2.length) {
            vCurva2.add(curva2[k]);
            ++k;
        }
        T = this.getCurvaLinearizada(curva1);
        S = this.getCurvaLinearizada(curva2);
        Vector<Double> tamFinal = new Vector<Double>();
        int i = 0;
        while (i < T.size()) {
            tamFinal.add(new Double((Double)T.elementAt(i)));
            ++i;
        }
        i = 0;
        while (i < S.size()) {
            if (!tamFinal.contains(new Double((Double)S.elementAt(i)))) {
                tamFinal.add(new Double((Double)S.elementAt(i)));
            }
            ++i;
        }
        int tam = tamFinal.size();
        int k2 = 1;
        while (k2 < tam) {
            int j;
            float[][] curvaTemp;
            float[] pontoFim;
            float[] pontoIni;
            double r;
            double parcial;
            double total;
            float[] ponto;
            double s_temp;
            double t_temp = (Double)T.elementAt(k2);
            if (t_temp == (s_temp = ((Double)S.elementAt(k2)).doubleValue())) {
                --tam;
            } else if ((Double)T.get(k2) > (Double)S.get(k2)) {
                ponto = new float[3];
                total = (Double)T.get(k2) - (Double)T.get(k2 - 1);
                parcial = (Double)S.get(k2) - (Double)S.get(k2 - 1);
                r = parcial / total;
                pontoIni = new float[3];
                pontoFim = new float[3];
                pontoIni = (float[])vCurva1.elementAt(k2 - 1);
                pontoFim = (float[])vCurva1.elementAt(k2 >= vCurva1.size() ? 0 : k2);
                ponto[0] = (float)(1.0 - r) * pontoIni[0] + (float)r * pontoFim[0];
                ponto[1] = (float)(1.0 - r) * pontoIni[1] + (float)r * pontoFim[1];
                ponto[2] = pontoIni[2];
                vCurva1.add(k2, ponto);
                curvaTemp = new float[vCurva1.size()][3];
                j = 0;
                while (j < vCurva1.size()) {
                    curvaTemp[j] = (float[])vCurva1.get(j);
                    ++j;
                }
                T = this.getCurvaLinearizada(curvaTemp);
            } else {
                ponto = new float[3];
                total = (Double)S.get(k2) - (Double)S.get(k2 - 1);
                parcial = (Double)T.get(k2) - (Double)T.get(k2 - 1);
                r = parcial / total;
                pontoIni = new float[3];
                pontoFim = new float[3];
                pontoIni = (float[])vCurva2.elementAt(k2 - 1);
                pontoFim = (float[])vCurva2.elementAt(k2 >= vCurva2.size() ? 0 : k2);
                ponto[0] = (float)(1.0 - r) * pontoIni[0] + (float)r * pontoFim[0];
                ponto[1] = (float)(1.0 - r) * pontoIni[1] + (float)r * pontoFim[1];
                ponto[2] = pontoIni[2];
                vCurva2.add(k2, ponto);
                curvaTemp = new float[vCurva2.size()][3];
                j = 0;
                while (j < vCurva2.size()) {
                    curvaTemp[j] = (float[])vCurva2.get(j);
                    ++j;
                }
                S = this.getCurvaLinearizada(curvaTemp);
            }
            ++k2;
        }
        float[][] novaCurva1 = new float[vCurva1.size()][3];
        int k3 = 0;
        while (k3 < vCurva1.size()) {
            novaCurva1[k3] = (float[])vCurva1.get(k3);
            ++k3;
        }
        float[][] novaCurva2 = new float[vCurva2.size()][3];
        int k4 = 0;
        while (k4 < vCurva2.size()) {
            novaCurva2[k4] = (float[])vCurva2.get(k4);
            ++k4;
        }
        vetor.add(novaCurva1);
        vetor.add(novaCurva2);
        return vetor;
    }

    public Vector<Double> getCurvaLinearizada(float[][] curva) {
        Vector<Double> vetor = new Vector<Double>();
        double distanciaTotal = 0.0;
        double distanciaAtual = 0.0;
        double valor = 0.0;
        int k = 1;
        while (k <= curva.length) {
            distanciaTotal += this.getDistancia2DEntrePontos(curva[k - 1], curva[k >= curva.length ? 0 : k]);
            ++k;
        }
        vetor.add(new Double(valor));
        k = 1;
        while (k <= curva.length) {
            valor = (distanciaAtual += this.getDistancia2DEntrePontos(curva[k - 1], curva[k >= curva.length ? 0 : k])) / distanciaTotal;
            vetor.add(new Double(valor));
            ++k;
        }
        return vetor;
    }

    public float[][] distribuicaoProximal(float[][] primeiraCurva, float[][] segundaCurva, int quantidadeTotalPontos) {
        int totalPontosCurvaMaior = 0;
        int totalPontosCurvaMenor = 0;
        if (primeiraCurva.length >= segundaCurva.length) {
            totalPontosCurvaMaior = primeiraCurva.length;
            totalPontosCurvaMenor = segundaCurva.length;
        } else {
            totalPontosCurvaMaior = segundaCurva.length;
            totalPontosCurvaMenor = primeiraCurva.length;
        }
        float[][] curvaAuxMaior = new float[1][3];
        float[][] curvaAuxMenor = new float[1][3];
        float[][] pontosLigadosCurvaMaior = new float[totalPontosCurvaMaior][3];
        float[][] novaCurva = new float[totalPontosCurvaMaior][3];
        float[][] pontosLigadosCurvaMenor = new float[totalPontosCurvaMenor][3];
        int[] pontoLigado = new int[totalPontosCurvaMaior];
        int indice = 0;
        double distanciaAux = 0.0;
        if (primeiraCurva.length >= segundaCurva.length) {
            float[][] maiorCurva = new float[primeiraCurva.length][3];
            float[][] menorCurva = new float[segundaCurva.length][3];
            int a = 0;
            while (a < totalPontosCurvaMaior) {
                maiorCurva[a] = primeiraCurva[a];
                ++a;
            }
            a = 0;
            while (a < totalPontosCurvaMenor) {
                menorCurva[a] = segundaCurva[a];
                ++a;
            }
            int cont = 0;
            while (cont < totalPontosCurvaMenor) {
                double menorDistancia = this.getDistancia2DEntrePontos(maiorCurva[cont], menorCurva[cont]);
                int cont2 = 0;
                while (cont2 < totalPontosCurvaMaior) {
                    distanciaAux = this.getDistancia2DEntrePontos(maiorCurva[cont], menorCurva[cont2]);
                    if (distanciaAux < 0.0) {
                        distanciaAux *= -1.0;
                    }
                    if (menorDistancia >= distanciaAux) {
                        menorDistancia = distanciaAux;
                        curvaAuxMaior[0] = maiorCurva[cont2];
                        curvaAuxMenor[0] = menorCurva[cont];
                        indice = cont2;
                    }
                    ++cont2;
                }
                pontosLigadosCurvaMaior[cont] = curvaAuxMaior[0];
                pontosLigadosCurvaMenor[cont] = curvaAuxMenor[0];
                pontoLigado[cont] = indice;
                ++cont;
            }
            cont = 0;
            while (cont < totalPontosCurvaMaior) {
                if (pontosLigadosCurvaMaior[cont][0] == 0.0f && pontosLigadosCurvaMaior[cont][1] == 0.0f && pontosLigadosCurvaMaior[cont][2] == 0.0f && cont != pontoLigado[cont]) {
                    float[][] a2 = new float[totalPontosCurvaMaior][3];
                    float[][] b = new float[totalPontosCurvaMaior][3];
                    float[][] p = new float[totalPontosCurvaMaior][3];
                    if (cont == 0) {
                        a2[0][0] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][0];
                        a2[0][1] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][1];
                        a2[0][2] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][2];
                        b[1][0] = pontosLigadosCurvaMenor[1][0];
                        b[1][1] = pontosLigadosCurvaMenor[1][1];
                        b[1][2] = pontosLigadosCurvaMenor[1][2];
                        p[cont][0] = maiorCurva[cont][0];
                        p[cont][1] = maiorCurva[cont][1];
                        p[cont][2] = maiorCurva[cont][2];
                    } else if (cont >= totalPontosCurvaMenor - 1) {
                        a2[0][0] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][0];
                        a2[0][1] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][1];
                        a2[0][2] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][2];
                        b[1][0] = pontosLigadosCurvaMenor[0][0];
                        b[1][1] = pontosLigadosCurvaMenor[0][1];
                        b[1][2] = pontosLigadosCurvaMenor[0][2];
                        p[cont][0] = maiorCurva[cont][0];
                        p[cont][1] = maiorCurva[cont][1];
                        p[cont][2] = maiorCurva[cont][2];
                    } else {
                        a2[0][0] = pontosLigadosCurvaMenor[cont - 1][0];
                        a2[0][1] = pontosLigadosCurvaMenor[cont - 1][1];
                        a2[0][2] = pontosLigadosCurvaMenor[cont - 1][2];
                        b[1][0] = pontosLigadosCurvaMenor[cont + 1][0];
                        b[1][1] = pontosLigadosCurvaMenor[cont + 1][1];
                        b[1][2] = pontosLigadosCurvaMenor[cont + 1][2];
                        p[cont][0] = maiorCurva[cont][0];
                        p[cont][1] = maiorCurva[cont][1];
                        p[cont][2] = maiorCurva[cont][2];
                    }
                    float[][] tx = new float[totalPontosCurvaMaior][3];
                    tx[cont][0] = b[1][0] - a2[0][0] == 0.0f ? 0.0f : (p[cont][0] - a2[0][0]) / (b[1][0] - a2[0][0]);
                    float[][] ty = new float[totalPontosCurvaMaior][3];
                    ty[cont][1] = b[1][1] - a2[0][1] == 0.0f ? 0.0f : (p[cont][1] - a2[0][1]) / (b[1][1] - a2[0][1]);
                    float[][] tz = new float[totalPontosCurvaMaior][3];
                    tz[cont][2] = b[1][2] - a2[0][2] == 0.0f ? 0.0f : (p[cont][2] - a2[0][2]) / (b[1][2] - a2[0][2]);
                    float PLinhatx = 0.0f;
                    float PLinhaty = 0.0f;
                    float PLinhatz = 0.0f;
                    PLinhatx = a2[0][0] + tx[cont][0] * (b[1][0] - a2[0][0]);
                    PLinhaty = a2[0][1] + ty[cont][1] * (b[1][1] - a2[0][1]);
                    PLinhatz = a2[0][2] + tz[cont][2] * (b[1][2] - a2[0][2]);
                    if ((double)(b[1][0] * a2[0][0] + b[1][1] * a2[0][1] + b[1][2] * a2[0][2]) / (Math.sqrt((b[1][0] - a2[0][0]) * (b[1][0] - a2[0][0]) + (b[1][1] - a2[0][1]) * (b[1][1] - a2[0][1]) + (b[1][2] - a2[0][2]) * (b[1][2] - a2[0][2])) * Math.sqrt((PLinhatx - p[cont][0]) * (PLinhatx - p[cont][0]) + (PLinhaty - p[cont][1]) * (PLinhaty - p[cont][1]) + (PLinhatz - p[cont][2]) * (PLinhatz - p[cont][2]))) == 0.0) {
                        novaCurva[cont][0] = PLinhatx;
                        novaCurva[cont][1] = PLinhaty;
                        novaCurva[cont][2] = PLinhatz;
                        System.out.println(novaCurva[cont][0] + novaCurva[cont][1] + novaCurva[cont][2]);
                    }
                }
                ++cont;
            }
        } else {
            float[][] maiorCurva = new float[segundaCurva.length][3];
            float[][] menorCurva = new float[primeiraCurva.length][3];
            int a = 0;
            while (a < totalPontosCurvaMaior) {
                maiorCurva[a] = segundaCurva[a];
                ++a;
            }
            a = 0;
            while (a < totalPontosCurvaMenor) {
                menorCurva[a] = primeiraCurva[a];
                ++a;
            }
            int cont = 0;
            while (cont < totalPontosCurvaMenor) {
                double menorDistancia = this.getDistancia2DEntrePontos(maiorCurva[cont], menorCurva[cont]);
                int cont2 = 0;
                while (cont2 < totalPontosCurvaMaior) {
                    distanciaAux = this.getDistancia2DEntrePontos(maiorCurva[cont], menorCurva[cont2]);
                    if (distanciaAux < 0.0) {
                        distanciaAux *= -1.0;
                    }
                    if (menorDistancia >= distanciaAux) {
                        menorDistancia = distanciaAux;
                        curvaAuxMaior[0] = maiorCurva[cont2];
                        curvaAuxMenor[0] = menorCurva[cont];
                        indice = cont2;
                    }
                    ++cont2;
                }
                if (curvaAuxMaior[0] == pontosLigadosCurvaMaior[cont - 1]) {
                    pontosLigadosCurvaMenor[cont - 1][0] = 0.0f;
                    pontosLigadosCurvaMenor[cont - 1][1] = 0.0f;
                    pontosLigadosCurvaMenor[cont - 1][2] = 0.0f;
                }
                pontosLigadosCurvaMaior[cont] = curvaAuxMaior[0];
                pontosLigadosCurvaMenor[cont] = curvaAuxMenor[0];
                pontoLigado[cont] = indice;
                ++cont;
            }
            cont = 0;
            while (cont < totalPontosCurvaMaior) {
                if (pontosLigadosCurvaMaior[pontoLigado[cont]][0] == 0.0f && pontosLigadosCurvaMaior[pontoLigado[cont]][1] == 0.0f && pontosLigadosCurvaMaior[pontoLigado[cont]][2] == 0.0f && cont != pontoLigado[cont]) {
                    float[][] a3 = new float[totalPontosCurvaMaior][3];
                    float[][] b = new float[totalPontosCurvaMaior][3];
                    float[][] p = new float[totalPontosCurvaMaior][3];
                    if (cont == 0) {
                        a3[0][0] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][0];
                        a3[0][1] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][1];
                        a3[0][2] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][2];
                        b[1][0] = pontosLigadosCurvaMenor[1][0];
                        b[1][1] = pontosLigadosCurvaMenor[1][1];
                        b[1][2] = pontosLigadosCurvaMenor[1][2];
                        p[cont][0] = maiorCurva[cont][0];
                        p[cont][1] = maiorCurva[cont][1];
                        p[cont][2] = maiorCurva[cont][2];
                    } else if (cont >= totalPontosCurvaMenor - 1) {
                        a3[0][0] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][0];
                        a3[0][1] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][1];
                        a3[0][2] = pontosLigadosCurvaMenor[totalPontosCurvaMenor - 1][2];
                        b[1][0] = pontosLigadosCurvaMenor[0][0];
                        b[1][1] = pontosLigadosCurvaMenor[0][1];
                        b[1][2] = pontosLigadosCurvaMenor[0][2];
                        p[cont][0] = maiorCurva[cont][0];
                        p[cont][1] = maiorCurva[cont][1];
                        p[cont][2] = maiorCurva[cont][2];
                    } else {
                        a3[0][0] = pontosLigadosCurvaMenor[cont - 1][0];
                        a3[0][1] = pontosLigadosCurvaMenor[cont - 1][1];
                        a3[0][2] = pontosLigadosCurvaMenor[cont - 1][2];
                        b[1][0] = pontosLigadosCurvaMenor[cont + 1][0];
                        b[1][1] = pontosLigadosCurvaMenor[cont + 1][1];
                        b[1][2] = pontosLigadosCurvaMenor[cont + 1][2];
                        p[cont][0] = maiorCurva[cont][0];
                        p[cont][1] = maiorCurva[cont][1];
                        p[cont][2] = maiorCurva[cont][2];
                    }
                    float[][] tx = new float[totalPontosCurvaMaior][3];
                    tx[cont][0] = b[1][0] - a3[0][0] == 0.0f ? 0.0f : (p[cont][0] - a3[0][0]) / (b[1][0] - a3[0][0]);
                    float[][] ty = new float[totalPontosCurvaMaior][3];
                    ty[cont][1] = b[1][1] - a3[0][1] == 0.0f ? 0.0f : (p[cont][1] - a3[0][1]) / (b[1][1] - a3[0][1]);
                    float[][] tz = new float[totalPontosCurvaMaior][3];
                    tz[cont][2] = b[1][2] - a3[0][2] == 0.0f ? 0.0f : (p[cont][2] - a3[0][2]) / (b[1][2] - a3[0][2]);
                    float PLinhatx = 0.0f;
                    float PLinhaty = 0.0f;
                    float PLinhatz = 0.0f;
                    PLinhatx = a3[0][0] + tx[cont][0] * (b[1][0] - a3[0][0]);
                    PLinhaty = a3[0][1] + ty[cont][1] * (b[1][1] - a3[0][1]);
                    PLinhatz = a3[0][2] + tz[cont][2] * (b[1][2] - a3[0][2]);
                    if ((double)(b[1][0] * a3[0][0] + b[1][1] * a3[0][1] + b[1][2] * a3[0][2]) / (Math.sqrt((b[1][0] - a3[0][0]) * (b[1][0] - a3[0][0]) + (b[1][1] - a3[0][1]) * (b[1][1] - a3[0][1]) + (b[1][2] - a3[0][2]) * (b[1][2] - a3[0][2])) * Math.sqrt((PLinhatx - p[cont][0]) * (PLinhatx - p[cont][0]) + (PLinhaty - p[cont][1]) * (PLinhaty - p[cont][1]) + (PLinhatz - p[cont][2]) * (PLinhatz - p[cont][2]))) == 0.0) {
                        novaCurva[cont][0] = PLinhatx;
                        novaCurva[cont][1] = PLinhaty;
                        novaCurva[cont][2] = PLinhatz;
                        System.out.println(novaCurva[cont][0] + novaCurva[cont][1] + novaCurva[cont][2]);
                    }
                }
                ++cont;
            }
        }
        return novaCurva;
    }
}

