/*
 * Decompiled with CFR 0.152.
 */
package com.udesc.larva.delta.files;

import com.udesc.larva.delta.files.FiltroDeExtensao;
import com.udesc.larva.delta.interpolation.ParametrosIniciais;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class XMLtoVRML {
    private String nomeArquivo;
    private RandomAccessFile file;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParametrosIniciais carregarXML() {
        ParametrosIniciais parametro = null;
        String[] pontos = new String[100];
        String[] ponto = new String[2];
        try {
            JFileChooser arquivo = new JFileChooser();
            arquivo.setDialogTitle("Escolha o arquivo XML a ser carregado");
            FiltroDeExtensao filter = new FiltroDeExtensao("xml", "Arquivos XML");
            arquivo.addChoosableFileFilter(filter);
            if (arquivo.showOpenDialog(arquivo) != 0) return null;
            BufferedReader br = new BufferedReader(new FileReader(arquivo.getSelectedFile()));
            File arq = arquivo.getSelectedFile();
            this.nomeArquivo = arq.getPath();
            try {
                parametro = new ParametrosIniciais();
                br.readLine();
                br.readLine();
                br.readLine();
                br.readLine();
                br.readLine();
                String line_str = br.readLine();
                parametro.setNumeroInicialTotalPontos(Integer.parseInt(line_str.substring(10, line_str.length() - 11)));
                br.readLine();
                line_str = br.readLine();
                parametro.setNumeroPlanos(Integer.parseInt(line_str.substring(10, line_str.length() - 11)));
                if (parametro.getNumeroPlanos() < 2) {
                    JOptionPane.showMessageDialog(null, "Erro: O arquivo n\u00e3o cont\u00e9m planos suficientes para a Interpola\u00e7\u00e3o ");
                    return null;
                }
                line_str = br.readLine();
                try {
                    parametro.setDistanciaEntrePlanos(Float.parseFloat(line_str.substring(13, line_str.length() - 14)));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Erro: A dist\u00e3ncia entre planos n\u00e3o \u00e9 v\u00e1lida");
                    return null;
                }
                parametro.setPlanos(new float[parametro.getNumeroPlanos()][][][]);
                int i = 0;
                block6: while (i < parametro.getNumeroPlanos()) {
                    br.readLine();
                    line_str = br.readLine();
                    parametro.setNumeroCurvasPorPlano(Integer.parseInt(line_str.substring(10, line_str.length() - 11)));
                    parametro.getPlanos()[i] = new float[parametro.getNumeroCurvasPorPlano()][][];
                    int j = 0;
                    block7: while (true) {
                        if (j >= parametro.getNumeroCurvasPorPlano()) {
                            ++i;
                            continue block6;
                        }
                        line_str = br.readLine();
                        String dados = line_str.substring(7, line_str.length() - 8);
                        pontos = dados.split("  ");
                        parametro.getPlanos()[i][j] = new float[pontos.length][3];
                        int k = 0;
                        while (true) {
                            if (k >= pontos.length) {
                                ++j;
                                continue block7;
                            }
                            ponto = pontos[k].split(" ");
                            parametro.getPlanos()[i][j][k][0] = Float.parseFloat(ponto[0]);
                            parametro.getPlanos()[i][j][k][1] = Float.parseFloat(ponto[1]);
                            parametro.getPlanos()[i][j][k][2] = (float)(i + 1) * parametro.getDistanciaEntrePlanos();
                            ++k;
                        }
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Erro: Os dados do arquivo n\u00e3o s\u00e3o v\u00e1lidos");
                return null;
            }
            br.close();
            return parametro;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Erro: " + e.toString());
            return null;
        }
    }

    public void gerarFace(float[][] curva) {
        String ptsCurva = "";
        String geometria = "";
        String ligCurva = "";
        String topologia = "";
        int nPonto = 0;
        int k = 0;
        while (k < curva.length) {
            ptsCurva = String.valueOf(ptsCurva) + curva[k][0] + " " + curva[k][2] + " " + curva[k][1] + " , \r\n";
            ligCurva = String.valueOf(ligCurva) + " " + nPonto;
            ++nPonto;
            ++k;
        }
        geometria = String.valueOf(geometria) + ptsCurva;
        topologia = String.valueOf(topologia) + ligCurva + " -1 \r\n";
        this.escreverFacesVRML(geometria, topologia);
    }

    public void gerarPlanos(ParametrosIniciais parametro) {
        String ptsCurva = "";
        String ptsPlano = "";
        String geometria = "";
        String ligCurva = "";
        String ligPlano = "";
        String topologia = "";
        int nPonto = 0;
        int i = 0;
        while (i < parametro.getNumeroPlanos()) {
            ligPlano = "";
            ptsPlano = "";
            int j = 0;
            while (j < parametro.getPlanos()[i].length) {
                ptsCurva = "";
                ligCurva = "";
                int k = 0;
                while (k < parametro.getPlanos()[i][j].length) {
                    ptsCurva = String.valueOf(ptsCurva) + parametro.getPlanos()[i][j][k][0] + " " + parametro.getPlanos()[i][j][k][2] + " " + parametro.getPlanos()[i][j][k][1] + " , \r\n";
                    ligCurva = String.valueOf(ligCurva) + " " + nPonto;
                    ++nPonto;
                    ++k;
                }
                ligPlano = String.valueOf(ligPlano) + ligCurva + " " + (nPonto - parametro.getPlanos()[i][j].length) + " -1 \r\n";
                ptsPlano = String.valueOf(ptsPlano) + ptsCurva;
                ++j;
            }
            geometria = String.valueOf(geometria) + ptsPlano;
            topologia = String.valueOf(topologia) + ligPlano + "\r\n";
            this.escreverLinhasVRML(geometria, topologia);
            geometria = "";
            topologia = "";
            nPonto = 0;
            ++i;
        }
    }

    public void abrirVRML() {
        this.nomeArquivo = String.valueOf(this.nomeArquivo.substring(0, this.nomeArquivo.length() - 4)) + ".wrl";
        File arquivoNome = new File(this.nomeArquivo);
        if (arquivoNome == null || arquivoNome.getName().equals("")) {
            JOptionPane.showMessageDialog(null, "Nome de Arquivo Inv\u00e1lido", "Nome de Arquivo Inv\u00e1lido", 0);
        } else {
            try {
                this.file = new RandomAccessFile(arquivoNome, "rw");
                this.file.writeBytes("#VRML V2.0 utf8 \r\n\r\nViewpoint {position 350 300 1100 orientation 1 0 0 -0.05}Group{ children[\r\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void escreverFacesVRML(String geometria, String topologia) {
        try {
            this.file.writeBytes("Shape { geometry IndexedFaceSet { coord Coordinate { point [\r\n" + geometria + "] } coordIndex [\r\n" + topologia + "]solid FALSE } appearance Appearance { material Material { diffuseColor .35 .41 .43 emissiveColor .14 .16 .17  shininess .0 } } }");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void escreverLinhasVRML(String geometria, String topologia) {
        try {
            this.file.writeBytes("Shape { geometry IndexedLineSet { coord Coordinate { point [\r\n" + geometria + "] } coordIndex [\r\n" + topologia + "]} appearance Appearance { material Material { diffuseColor .35 .41 .43 emissiveColor .14 .16 .17  shininess .0 } } }");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fecharVRML() {
        try {
            this.file.writeBytes("]}");
            this.file.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

